/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsConfiguration
extends ServiceConfiguration {
    private static final long serialVersionUID = 6943138644427163149L;
    private static final String DEFAULT_IP_PORT = "53";
    private static final String DEFAULT_PID = "org.apache.dns";
    private static final String DEFAULT_NAME = "Apache DNS Service";
    private static final String DEFAULT_PREFIX = "dns.";

    public DnsConfiguration() {
        this(DnsConfiguration.getDefaultConfig(), 1);
    }

    public DnsConfiguration(String instanceId) {
        this(DnsConfiguration.getDefaultConfig(), 1);
        this.setInstanceId(instanceId);
    }

    public DnsConfiguration(Map<String, String> properties) {
        this(properties, 1);
    }

    public DnsConfiguration(Map<String, String> properties, int strategy) {
        if (properties == null) {
            this.configuration = DnsConfiguration.getDefaultConfig();
        } else {
            this.loadProperties(DEFAULT_PREFIX, properties, strategy);
        }
        int port = this.getPort();
        if (port < 1 || port > 65535) {
            throw new ConfigurationException("Invalid value:  ipPort=" + port);
        }
    }

    public static Map<String, String> getDefaultConfig() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("service.pid", DEFAULT_PID);
        defaults.put("ipPort", DEFAULT_IP_PORT);
        return defaults;
    }

    public boolean isDifferent(Dictionary config) {
        int port = this.getPort();
        return port != Integer.parseInt((String)config.get("ipPort"));
    }

    public String getName() {
        return DEFAULT_NAME;
    }

    public int getPort() {
        String key = "ipPort";
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return Integer.parseInt(DEFAULT_IP_PORT);
    }

    public int getBufferSize() {
        String key = "buffer.size";
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return 1024;
    }
}

