/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.protocol;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.server.dns.io.encoder.AddressRecordEncoder;
import org.apache.directory.server.dns.io.encoder.CanonicalNameRecordEncoder;
import org.apache.directory.server.dns.io.encoder.MailExchangeRecordEncoder;
import org.apache.directory.server.dns.io.encoder.NameServerRecordEncoder;
import org.apache.directory.server.dns.io.encoder.PointerRecordEncoder;
import org.apache.directory.server.dns.io.encoder.QuestionRecordEncoder;
import org.apache.directory.server.dns.io.encoder.RecordEncoder;
import org.apache.directory.server.dns.io.encoder.ResourceRecordEncoder;
import org.apache.directory.server.dns.io.encoder.ServerSelectionRecordEncoder;
import org.apache.directory.server.dns.io.encoder.StartOfAuthorityRecordEncoder;
import org.apache.directory.server.dns.io.encoder.TextRecordEncoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.QuestionRecords;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecords;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsEncoder
implements ProtocolEncoder {
    private static final Logger log = LoggerFactory.getLogger((Class)DnsEncoder.class);
    private static final Map DEFAULT_ENCODERS;

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) {
        ByteBuffer buf = ByteBuffer.allocate((int)1024);
        this.encode(buf, (DnsMessage)message);
        buf.flip();
        out.write(buf);
    }

    public void encode(ByteBuffer byteBuffer, DnsMessage message) {
        byteBuffer.putShort(message.getTransactionId());
        byte header = 0;
        header = this.encodeMessageType(message.getMessageType(), header);
        header = this.encodeOpCode(message.getOpCode(), header);
        header = this.encodeAuthoritativeAnswer(message.isAuthoritativeAnswer(), header);
        header = this.encodeTruncated(message.isTruncated(), header);
        header = this.encodeRecursionDesired(message.isRecursionDesired(), header);
        byteBuffer.put(header);
        header = 0;
        header = this.encodeRecursionAvailable(message.isRecursionAvailable(), header);
        header = this.encodeResponseCode(message.getResponseCode(), header);
        byteBuffer.put(header);
        byteBuffer.putShort((short)message.getQuestionRecords().size());
        byteBuffer.putShort((short)message.getAnswerRecords().size());
        byteBuffer.putShort((short)message.getAuthorityRecords().size());
        byteBuffer.putShort((short)message.getAdditionalRecords().size());
        this.encodeRecords(message.getQuestionRecords(), byteBuffer);
        this.encodeRecords(message.getAnswerRecords(), byteBuffer);
        this.encodeRecords(message.getAuthorityRecords(), byteBuffer);
        this.encodeRecords(message.getAdditionalRecords(), byteBuffer);
    }

    private void encodeRecords(QuestionRecords questions, ByteBuffer byteBuffer) {
        QuestionRecordEncoder encoder = new QuestionRecordEncoder();
        Iterator it = questions.iterator();
        while (it.hasNext()) {
            QuestionRecord question = (QuestionRecord)it.next();
            encoder.encode(byteBuffer, question);
        }
    }

    private void encodeRecords(ResourceRecords records, ByteBuffer byteBuffer) {
        Iterator it = records.iterator();
        while (it.hasNext()) {
            ResourceRecord record = (ResourceRecord)it.next();
            try {
                this.encode(byteBuffer, record);
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    private void encode(ByteBuffer out, ResourceRecord record) throws IOException {
        RecordType type = record.getRecordType();
        RecordEncoder encoder = (RecordEncoder)DEFAULT_ENCODERS.get(type);
        if (encoder == null) {
            throw new IOException("Encoder unavailable for " + type);
        }
        encoder.encode(out, record);
    }

    private byte encodeMessageType(MessageType messageType, byte header) {
        byte oneBit = (byte)(messageType.getOrdinal() & 1);
        return (byte)(oneBit << 7 | header);
    }

    private byte encodeOpCode(OpCode opCode, byte header) {
        byte fourBits = (byte)(opCode.getOrdinal() & 0xF);
        return (byte)(fourBits << 3 | header);
    }

    private byte encodeAuthoritativeAnswer(boolean authoritative, byte header) {
        if (authoritative) {
            header = (byte)(4 | header);
        }
        return header;
    }

    private byte encodeTruncated(boolean truncated, byte header) {
        if (truncated) {
            header = (byte)(2 | header);
        }
        return header;
    }

    private byte encodeRecursionDesired(boolean recursionDesired, byte header) {
        if (recursionDesired) {
            header = (byte)(1 | header);
        }
        return header;
    }

    private byte encodeRecursionAvailable(boolean recursionAvailable, byte header) {
        if (recursionAvailable) {
            header = (byte)(0x80 | header);
        }
        return header;
    }

    private byte encodeResponseCode(ResponseCode responseCode, byte header) {
        byte fourBits = (byte)(responseCode.getOrdinal() & 0xF);
        return (byte)(fourBits | header);
    }

    public void dispose(IoSession arg0) throws Exception {
    }

    static {
        HashMap<RecordType, ResourceRecordEncoder> map = new HashMap<RecordType, ResourceRecordEncoder>();
        map.put(RecordType.SOA, new StartOfAuthorityRecordEncoder());
        map.put(RecordType.A, new AddressRecordEncoder());
        map.put(RecordType.NS, new NameServerRecordEncoder());
        map.put(RecordType.CNAME, new CanonicalNameRecordEncoder());
        map.put(RecordType.PTR, new PointerRecordEncoder());
        map.put(RecordType.MX, new MailExchangeRecordEncoder());
        map.put(RecordType.SRV, new ServerSelectionRecordEncoder());
        map.put(RecordType.TXT, new TextRecordEncoder());
        DEFAULT_ENCODERS = Collections.unmodifiableMap(map);
    }
}

