/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.protocol;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.server.dns.io.decoder.Decoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.QuestionRecords;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecordImpl;
import org.apache.directory.server.dns.messages.ResourceRecords;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsDecoder
implements ProtocolDecoder {
    private static final Logger log = LoggerFactory.getLogger((Class)DnsDecoder.class);
    private static final Map DEFAULT_DECODERS;

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) {
        out.write((Object)this.decode(in));
    }

    DnsMessage decode(ByteBuffer in) {
        DnsMessageModifier modifier = new DnsMessageModifier();
        modifier.setTransactionId(in.getShort());
        byte header = in.get();
        modifier.setMessageType(this.decodeMessageType(header));
        modifier.setOpCode(this.decodeOpCode(header));
        modifier.setAuthoritativeAnswer(this.decodeAuthoritativeAnswer(header));
        modifier.setTruncated(this.decodeTruncated(header));
        modifier.setRecursionDesired(this.decodeRecursionDesired(header));
        header = in.get();
        modifier.setRecursionAvailable(this.decodeRecursionAvailable(header));
        modifier.setResponseCode(this.decodeResponseCode(header));
        short questionCount = in.getShort();
        short answerCount = in.getShort();
        short authorityCount = in.getShort();
        short additionalCount = in.getShort();
        modifier.setQuestionRecords(this.decodeQuestions(questionCount, in));
        modifier.setAnswerRecords(this.decodeRecords(answerCount, in));
        modifier.setAuthorityRecords(this.decodeRecords(authorityCount, in));
        modifier.setAdditionalRecords(this.decodeRecords(additionalCount, in));
        return modifier.getDnsMessage();
    }

    private ResourceRecords decodeRecords(short recordCount, ByteBuffer byteBuffer) {
        ResourceRecords records = new ResourceRecords(recordCount);
        for (int ii = 0; ii < recordCount; ++ii) {
            String domainName = this.decodeDomainName(byteBuffer);
            RecordType recordType = RecordType.getTypeByOrdinal(byteBuffer.getShort());
            RecordClass recordClass = RecordClass.getTypeByOrdinal(byteBuffer.getShort());
            int timeToLive = byteBuffer.getInt();
            short dataLength = byteBuffer.getShort();
            byte[] data = new byte[dataLength];
            byteBuffer.get(data);
            try {
                Map attributes = this.decode(recordType, data);
                records.add(new ResourceRecordImpl(domainName, recordType, recordClass, timeToLive, attributes));
                continue;
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
        return records;
    }

    private Map decode(RecordType type, byte[] resourceData) throws IOException {
        Decoder decoder = (Decoder)DEFAULT_DECODERS.get(type);
        if (decoder == null) {
            throw new IOException("Decoder unavailable for " + type);
        }
        return decoder.decode(resourceData);
    }

    private QuestionRecords decodeQuestions(short questionCount, ByteBuffer byteBuffer) {
        QuestionRecords questions = new QuestionRecords(questionCount);
        for (int ii = 0; ii < questionCount; ++ii) {
            String domainName = this.decodeDomainName(byteBuffer);
            RecordType recordType = RecordType.getTypeByOrdinal(byteBuffer.getShort());
            RecordClass recordClass = RecordClass.getTypeByOrdinal(byteBuffer.getShort());
            questions.add(new QuestionRecord(domainName, recordType, recordClass));
        }
        return questions;
    }

    private String decodeDomainName(ByteBuffer byteBuffer) {
        StringBuffer domainName = new StringBuffer();
        this.recurseDomainName(domainName, byteBuffer);
        return domainName.toString();
    }

    private void recurseDomainName(StringBuffer domainName, ByteBuffer byteBuffer) {
        boolean isLabelLength;
        byte currentByte = byteBuffer.get();
        boolean isCompressed = (currentByte & 0xFFFFFFC0) == -64;
        boolean bl = isLabelLength = currentByte != 0 && !isCompressed;
        if (isCompressed) {
            byte position = byteBuffer.get();
            int originalPosition = byteBuffer.position();
            byteBuffer.position((int)position);
            byte labelLength = byteBuffer.get();
            this.getLabel(labelLength, byteBuffer, domainName);
            this.recurseDomainName(domainName, byteBuffer);
            byteBuffer.position(originalPosition);
        }
        if (isLabelLength) {
            byte labelLength = currentByte;
            this.getLabel(labelLength, byteBuffer, domainName);
            this.recurseDomainName(domainName, byteBuffer);
        }
    }

    private void getLabel(int labelLength, ByteBuffer byteBuffer, StringBuffer domainName) {
        for (int jj = 0; jj < labelLength; ++jj) {
            char character = (char)byteBuffer.get();
            domainName.append(character);
        }
        if (byteBuffer.get(byteBuffer.position()) != 0) {
            domainName.append(".");
        }
    }

    private MessageType decodeMessageType(byte header) {
        return MessageType.getTypeByOrdinal((header & 0x80) >>> 7);
    }

    private OpCode decodeOpCode(byte header) {
        return OpCode.getTypeByOrdinal((header & 0x78) >>> 3);
    }

    private boolean decodeAuthoritativeAnswer(byte header) {
        return (header & 4) >>> 2 == 1;
    }

    private boolean decodeTruncated(byte header) {
        return (header & 2) >>> 1 == 1;
    }

    private boolean decodeRecursionDesired(byte header) {
        return (header & 1) == 1;
    }

    private boolean decodeRecursionAvailable(byte header) {
        return (header & 0x80) >>> 7 == 1;
    }

    private ResponseCode decodeResponseCode(byte header) {
        return ResponseCode.getTypeByOrdinal(header & 0xF);
    }

    public void dispose(IoSession arg0) throws Exception {
    }

    static {
        HashMap map = new HashMap();
        DEFAULT_DECODERS = Collections.unmodifiableMap(map);
    }
}

