/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ResponseCode
implements Comparable {
    public static final ResponseCode NO_ERROR = new ResponseCode(0, "No error condition.");
    public static final ResponseCode FORMAT_ERROR = new ResponseCode(1, "The name server was unable to interpret the query.");
    public static final ResponseCode SERVER_FAILURE = new ResponseCode(2, "The name server was unable to process this query due to a problem with the name server.");
    public static final ResponseCode NAME_ERROR = new ResponseCode(3, "The domain name referenced in the query does not exist.");
    public static final ResponseCode NOT_IMPLEMENTED = new ResponseCode(4, "The name server does not support the requested kind of query.");
    public static final ResponseCode REFUSED = new ResponseCode(5, "The name server refuses to perform the specified operation for policy reasons.");
    private static final ResponseCode[] values = new ResponseCode[]{NO_ERROR, FORMAT_ERROR, SERVER_FAILURE, NAME_ERROR, NOT_IMPLEMENTED, REFUSED};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private ResponseCode(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public String getMessage() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object that) {
        return this.ordinal - ((ResponseCode)that).ordinal;
    }

    public static ResponseCode getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (ResponseCode.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NO_ERROR;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

