/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.io;

import java.nio.ByteBuffer;
import org.apache.directory.server.dhcp.io.DhcpOptionsEncoder;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.options.OptionsField;

public class DhcpMessageEncoder {
    public void encode(ByteBuffer byteBuffer, DhcpMessage message) {
        byteBuffer.put(message.getOpCode());
        byteBuffer.put(message.getHardwareAddressType());
        byteBuffer.put(message.getHardwareAddressLength());
        byteBuffer.put(message.getHardwareOptions());
        byteBuffer.putInt(message.getTransactionId());
        byteBuffer.putShort(message.getSeconds());
        byteBuffer.putShort(message.getFlags());
        byteBuffer.put(message.getActualClientAddress());
        byteBuffer.put(message.getAssignedClientAddress());
        byteBuffer.put(message.getNextServerAddress());
        byteBuffer.put(message.getRelayAgentAddress());
        byteBuffer.put(message.getClientHardwareAddress());
        byteBuffer.put(message.getServerHostname());
        byteBuffer.put(message.getBootFileName());
        OptionsField options = message.getOptions();
        DhcpOptionsEncoder optionsEncoder = new DhcpOptionsEncoder();
        optionsEncoder.encode(options, byteBuffer);
    }
}

