/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages;

import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.KerberosMessageType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.messages.value.KdcOptions;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.server.kerberos.shared.messages.value.RequestBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KdcRequest
extends KerberosMessage {
    private PaData[] preAuthData;
    private RequestBody requestBody;
    private byte[] bodyBytes;

    public KdcRequest(int pvno, KerberosMessageType messageType, PaData[] preAuthData, RequestBody requestBody) {
        super(pvno, messageType);
        this.preAuthData = preAuthData;
        this.requestBody = requestBody;
    }

    public KdcRequest(int pvno, KerberosMessageType messageType, PaData[] preAuthData, RequestBody requestBody, byte[] bodyBytes) {
        this(pvno, messageType, preAuthData, requestBody);
        this.bodyBytes = bodyBytes;
    }

    public PaData[] getPreAuthData() {
        return this.preAuthData;
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    public Ticket[] getAdditionalTickets() {
        return this.requestBody.getAdditionalTickets();
    }

    public HostAddresses getAddresses() {
        return this.requestBody.getAddresses();
    }

    public KerberosPrincipal getClientPrincipal() {
        return this.requestBody.getClientPrincipal();
    }

    public String getRealm() {
        return this.requestBody.getServerPrincipal().getRealm();
    }

    public EncryptedData getEncAuthorizationData() {
        return this.requestBody.getEncAuthorizationData();
    }

    public Set<EncryptionType> getEType() {
        return this.requestBody.getEType();
    }

    public KerberosTime getFrom() {
        return this.requestBody.getFrom();
    }

    public KdcOptions getKdcOptions() {
        return this.requestBody.getKdcOptions();
    }

    public int getNonce() {
        return this.requestBody.getNonce();
    }

    public KerberosTime getRtime() {
        return this.requestBody.getRtime();
    }

    public KerberosPrincipal getServerPrincipal() {
        return this.requestBody.getServerPrincipal();
    }

    public KerberosTime getTill() {
        return this.requestBody.getTill();
    }

    public boolean getOption(int option) {
        return this.requestBody.getKdcOptions().get(option);
    }

    public void setOption(int option) {
        this.requestBody.getKdcOptions().set(option);
    }

    public void clearOption(int option) {
        this.requestBody.getKdcOptions().clear(option);
    }
}

