/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.text.ParseException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.SearchResult;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.SamType;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntryModifier;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;

public class GetPrincipal
implements ContextOperation {
    private static final long serialVersionUID = 4598007518413451945L;
    private final KerberosPrincipal principal;

    public GetPrincipal(KerberosPrincipal principal) {
        this.principal = principal;
    }

    public Object execute(DirContext ctx, Name base) {
        if (this.principal == null) {
            return null;
        }
        String[] attrIDs = new String[]{"krb5PrincipalName", "krb5KeyVersionNumber", "krb5EncryptionType", "krb5Key", "apacheSamType", "krb5AccountDisabled", "krb5AccountExpirationTime", "krb5AccountLockedOut"};
        AttributesImpl matchAttrs = new AttributesImpl(true);
        matchAttrs.put((Attribute)new AttributeImpl("krb5PrincipalName", (Object)this.principal.getName()));
        PrincipalStoreEntry entry = null;
        try {
            NamingEnumeration<SearchResult> answer = ctx.search("", (Attributes)matchAttrs, attrIDs);
            if (answer.hasMore()) {
                SearchResult result = answer.next();
                Attributes attrs = result.getAttributes();
                if (attrs == null) {
                    return null;
                }
                entry = this.getEntry(attrs);
            }
        }
        catch (NamingException e) {
            return null;
        }
        return entry;
    }

    private PrincipalStoreEntry getEntry(Attributes attrs) throws NamingException {
        String val;
        PrincipalStoreEntryModifier modifier = new PrincipalStoreEntryModifier();
        String principal = (String)attrs.get("krb5PrincipalName").get();
        String encryptionType = (String)attrs.get("krb5EncryptionType").get();
        String keyVersionNumber = (String)attrs.get("krb5KeyVersionNumber").get();
        if (attrs.get("krb5AccountDisabled") != null) {
            val = (String)attrs.get("krb5AccountDisabled").get();
            modifier.setDisabled("true".equalsIgnoreCase(val));
        }
        if (attrs.get("krb5AccountLockedOut") != null) {
            val = (String)attrs.get("krb5AccountLockedOut").get();
            modifier.setLockedOut("true".equalsIgnoreCase(val));
        }
        if (attrs.get("krb5AccountExpirationTime") != null) {
            val = (String)attrs.get("krb5AccountExpirationTime").get();
            try {
                modifier.setExpiration(KerberosTime.getTime(val));
            }
            catch (ParseException e) {
                throw new InvalidAttributeValueException("Account expiration attribute krb5AccountExpirationTime contained an invalid value for generalizedTime: " + val);
            }
        }
        if (attrs.get("apacheSamType") != null) {
            String samType = (String)attrs.get("apacheSamType").get();
            modifier.setSamType(SamType.getTypeByOrdinal(Integer.parseInt(samType)));
        }
        Object key = attrs.get("krb5Key").get();
        byte[] keyBytes = null;
        if (key instanceof String) {
            String msg = "JNDI should not return a string for the kerberos key: JNDI property java.naming.ldap.attributes.binary must include the krb5key attribute.";
            throw new NamingException(msg);
        }
        keyBytes = (byte[])key;
        modifier.setKey(keyBytes);
        modifier.setPrincipal(new KerberosPrincipal(principal));
        modifier.setEncryptionType(Integer.parseInt(encryptionType));
        modifier.setKeyVersionNumber(Integer.parseInt(keyVersionNumber));
        return modifier.getEntry();
    }
}

