/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.util.ArrayList;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.value.SamType;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntryModifier;
import org.apache.directory.server.protocol.shared.store.ContextOperation;

public class GetAllPrincipals
implements ContextOperation {
    private static final long serialVersionUID = -1214321426487445132L;
    private static final String filter = "(objectClass=krb5Principal)";

    public Object execute(DirContext ctx, Name searchBaseDn) {
        SearchControls controls = new SearchControls();
        ArrayList<PrincipalStoreEntry> answers = new ArrayList<PrincipalStoreEntry>();
        try {
            Attributes attrs = null;
            NamingEnumeration<SearchResult> answer = ctx.search(searchBaseDn, filter, controls);
            while (answer.hasMore()) {
                SearchResult result = answer.next();
                attrs = result.getAttributes();
                PrincipalStoreEntry entry = this.getEntry(attrs);
                System.out.println("Result name is " + result.getName());
                answers.add(entry);
            }
            answer.close();
            PrincipalStoreEntry[] entries = new PrincipalStoreEntry[answers.size()];
            return answers.toArray(entries);
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private PrincipalStoreEntry getEntry(Attributes attrs) throws NamingException {
        PrincipalStoreEntryModifier modifier = new PrincipalStoreEntryModifier();
        String principal = (String)attrs.get("krb5PrincipalName").get();
        String encryptionType = (String)attrs.get("krb5EncryptionType").get();
        String keyVersionNumber = (String)attrs.get("krb5KeyVersionNumber").get();
        String commonName = (String)attrs.get("cn").get();
        if (attrs.get("apacheSamType") != null) {
            String samType = (String)attrs.get("apacheSamType").get();
            modifier.setSamType(SamType.getTypeByOrdinal(Integer.parseInt(samType)));
        }
        byte[] keyBytes = (byte[])attrs.get("krb5Key").get();
        modifier.setCommonName(commonName);
        modifier.setPrincipal(new KerberosPrincipal(principal));
        modifier.setEncryptionType(Integer.parseInt(encryptionType));
        modifier.setKeyVersionNumber(Integer.parseInt(keyVersionNumber));
        modifier.setKey(keyBytes);
        return modifier.getEntry();
    }
}

