/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.service;

import java.net.InetAddress;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.MessageType;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.mina.handler.chain.IoHandlerCommand;

public abstract class VerifyAuthHeader
implements IoHandlerCommand {
    private String contextKey = "context";

    public Authenticator verifyAuthHeader(ApplicationRequest authHeader, Ticket ticket, EncryptionKey serverKey, long clockSkew, ReplayCache replayCache, boolean emptyAddressesAllowed, InetAddress clientAddress, LockBox lockBox) throws KerberosException {
        if (authHeader.getProtocolVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        if (authHeader.getMessageType() != MessageType.KRB_AP_REQ) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
        }
        if (authHeader.getTicket().getVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        EncryptionKey ticketKey = null;
        ticketKey = authHeader.getOption(1) ? authHeader.getTicket().getSessionKey() : serverKey;
        if (ticketKey == null) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOKEY);
        }
        EncTicketPart encPart = (EncTicketPart)lockBox.unseal(EncTicketPart.class, ticketKey, ticket.getEncPart());
        ticket.setEncTicketPart(encPart);
        Authenticator authenticator = (Authenticator)lockBox.unseal(Authenticator.class, ticket.getSessionKey(), authHeader.getEncPart());
        if (!authenticator.getClientPrincipal().getName().equals(ticket.getClientPrincipal().getName())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADMATCH);
        }
        if (ticket.getClientAddresses() != null ? !ticket.getClientAddresses().contains(new HostAddress(clientAddress)) : !emptyAddressesAllowed) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADADDR);
        }
        if (replayCache.isReplay(authenticator.getClientTime(), authenticator.getClientPrincipal())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_REPEAT);
        }
        replayCache.save(authenticator.getClientTime(), authenticator.getClientPrincipal());
        if (!authenticator.getClientTime().isInClockSkew(clockSkew)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_SKEW);
        }
        if (ticket.getStartTime() != null && !ticket.getStartTime().isInClockSkew(clockSkew) || ticket.getFlag(7)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
        }
        if (!ticket.getEndTime().greaterThan(new KerberosTime())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
        }
        authHeader.setOption(2);
        return authenticator;
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

