/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SchemaViolationException;
import javax.naming.spi.DirStateFactory;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;

public class PrincipalStateFactory
implements DirStateFactory {
    public DirStateFactory.Result getStateToBind(Object obj, Name name, Context nameCtx, Hashtable environment, Attributes inAttrs) throws NamingException {
        if (obj instanceof PrincipalStoreEntry) {
            Attributes outAttrs = inAttrs == null ? new BasicAttributes(true) : (Attributes)inAttrs.clone();
            Attribute oc = outAttrs.get("objectClass");
            if (oc == null) {
                oc = new BasicAttribute("objectClass");
                outAttrs.put(oc);
            }
            if (!oc.contains("top")) {
                oc.add("top");
            }
            PrincipalStoreEntry p = (PrincipalStoreEntry)obj;
            if (!oc.contains("uidObject")) {
                oc.add("uidObject");
                if (p.getUserId() != null) {
                    outAttrs.put("uid", p.getUserId());
                } else {
                    throw new SchemaViolationException("Person must have uid.");
                }
            }
            if (!oc.contains("extensibleObject")) {
                oc.add("extensibleObject");
                outAttrs.put("apacheSamType", "7");
            }
            if (!oc.contains("person")) {
                oc.add("person");
                outAttrs.put("sn", p.getUserId());
                outAttrs.put("cn", p.getCommonName());
            }
            if (!oc.contains("organizationalPerson")) {
                oc.add("organizationalPerson");
            }
            if (!oc.contains("inetOrgPerson")) {
                oc.add("inetOrgPerson");
            }
            if (!oc.contains("krb5Principal")) {
                oc.add("krb5Principal");
            }
            if (!oc.contains("krb5KDCEntry")) {
                oc.add("krb5KDCEntry");
                String principal = p.getPrincipal().getName();
                byte[] keyBytes = p.getEncryptionKey().getKeyValue();
                int keyType = p.getEncryptionKey().getKeyType().getOrdinal();
                int keyVersion = p.getEncryptionKey().getKeyVersion();
                outAttrs.put("krb5PrincipalName", principal);
                outAttrs.put("krb5Key", keyBytes);
                outAttrs.put("krb5EncryptionType", Integer.toString(keyType));
                outAttrs.put("krb5KeyVersionNumber", Integer.toString(keyVersion));
            }
            DirStateFactory.Result r = new DirStateFactory.Result(obj, outAttrs);
            System.out.println("Result from obj " + obj);
            System.out.println("Result attrs " + outAttrs);
            return r;
        }
        System.out.println("ERROR:  entry was not correct type " + obj);
        return null;
    }

    public Object getStateToBind(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        throw new UnsupportedOperationException("Structural objectClass needed with additional attributes!");
    }
}

