/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages;

import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.directory.server.kerberos.shared.messages.MessageType;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.ApOptions;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;

public class ApplicationRequest
extends KerberosMessage {
    private ApOptions apOptions;
    private Ticket ticket;
    private EncryptedData encPart;
    private Authenticator authenticator;

    public ApplicationRequest() {
        super(MessageType.KRB_AP_REQ);
    }

    public ApplicationRequest(ApOptions apOptions, Ticket ticket, EncryptedData encPart) {
        super(MessageType.KRB_AP_REQ);
        this.apOptions = apOptions;
        this.ticket = ticket;
        this.encPart = encPart;
    }

    public ApOptions getApOptions() {
        return this.apOptions;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public boolean getOption(int option) {
        return this.apOptions.get(option);
    }

    public void setOption(int option) {
        this.apOptions.set(option);
    }

    public void clearOption(int option) {
        this.apOptions.clear(option);
    }

    public EncryptedData getEncPart() {
        return this.encPart;
    }

    public void setEncPart(EncryptedData data) {
        this.encPart = data;
    }

    public void setApOptions(ApOptions options) {
        this.apOptions = options;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }
}

