/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.messages.application.PrivateMessage;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class PrivateMessageEncoder {
    public byte[] encode(PrivateMessage message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence privateMessageSequence = this.encodePrivateMessageSequence(message);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)message.getMessageType().getOrdinal(), (DEREncodable)privateMessageSequence));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodePrivateMessageSequence(PrivateMessage message) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)message.getProtocolVersionNumber())));
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)message.getMessageType().getOrdinal())));
        sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)EncryptedDataEncoder.encodeSequence(message.getEncryptedPart())));
        return sequence;
    }
}

