/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.security.SecureRandom;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumEngine;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public abstract class EncryptionEngine {
    private static final SecureRandom random = new SecureRandom();

    public abstract ChecksumEngine getChecksumEngine();

    public abstract BlockCipher getBlockCipher();

    public abstract EncryptionType encryptionType();

    public abstract ChecksumType checksumType();

    public abstract CipherType keyType();

    public abstract int confounderSize();

    public abstract int checksumSize();

    public abstract int blockSize();

    public abstract int minimumPadSize();

    public abstract int keySize();

    public byte[] getDecryptedData(EncryptionKey key, EncryptedData data) {
        byte[] decryptedData = this.decrypt(data.getCipherText(), key.getKeyValue());
        return this.removeBytes(decryptedData, this.confounderSize(), this.checksumSize());
    }

    public EncryptedData getEncryptedData(EncryptionKey key, byte[] plainText) {
        byte[] conFounder = this.getRandomBytes(this.confounderSize());
        byte[] zeroedChecksum = new byte[this.checksumSize()];
        byte[] paddedPlainText = this.padString(plainText);
        byte[] dataBytes = this.concatenateBytes(conFounder, this.concatenateBytes(zeroedChecksum, paddedPlainText));
        byte[] checksumBytes = this.calculateChecksum(dataBytes);
        byte[] paddedDataBytes = this.padString(dataBytes);
        for (int i = this.confounderSize(); i < this.confounderSize() + this.checksumSize(); ++i) {
            paddedDataBytes[i] = checksumBytes[i - this.confounderSize()];
        }
        byte[] encryptedData = this.encrypt(paddedDataBytes, key.getKeyValue());
        return new EncryptedData(this.encryptionType(), key.getKeyVersion(), encryptedData);
    }

    private byte[] encrypt(byte[] data, byte[] key) {
        return this.processBlockCipher(true, data, key, null);
    }

    private byte[] decrypt(byte[] data, byte[] key) {
        return this.processBlockCipher(false, data, key, null);
    }

    private byte[] getRandomBytes(int size) {
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return bytes;
    }

    private byte[] padString(byte[] encodedString) {
        int x = encodedString.length < 8 ? encodedString.length : encodedString.length % 8;
        if (x == 0) {
            return encodedString;
        }
        byte[] paddedByteArray = new byte[8 - x + encodedString.length];
        for (int y = paddedByteArray.length - 1; y > encodedString.length - 1; --y) {
            paddedByteArray[y] = 0;
        }
        System.arraycopy(encodedString, 0, paddedByteArray, 0, encodedString.length);
        return paddedByteArray;
    }

    private byte[] concatenateBytes(byte[] array1, byte[] array2) {
        byte[] concatenatedBytes = new byte[array1.length + array2.length];
        for (int i = 0; i < array1.length; ++i) {
            concatenatedBytes[i] = array1[i];
        }
        for (int j = array1.length; j < concatenatedBytes.length; ++j) {
            concatenatedBytes[j] = array2[j - array1.length];
        }
        return concatenatedBytes;
    }

    private byte[] calculateChecksum(byte[] data) {
        ChecksumEngine digester = this.getChecksumEngine();
        return digester.calculateChecksum(data);
    }

    private byte[] removeBytes(byte[] array, int confounder, int checksum) {
        byte[] lessBytes = new byte[array.length - confounder - checksum];
        int j = 0;
        for (int i = confounder + checksum; i < array.length; ++i) {
            lessBytes[j] = array[i];
            ++j;
        }
        return lessBytes;
    }

    private byte[] processBlockCipher(boolean encrypt, byte[] data, byte[] key, byte[] ivec) {
        byte[] returnData = new byte[data.length];
        CBCBlockCipher cbcCipher = new CBCBlockCipher(this.getBlockCipher());
        KeyParameter keyParameter = new KeyParameter(key);
        if (ivec != null) {
            ParametersWithIV kpWithIV = new ParametersWithIV((CipherParameters)keyParameter, ivec);
            cbcCipher.init(encrypt, (CipherParameters)kpWithIV);
        } else {
            cbcCipher.init(encrypt, (CipherParameters)keyParameter);
        }
        int processedBytesLength = 0;
        for (int offset = 0; offset < returnData.length; offset += processedBytesLength) {
            try {
                processedBytesLength = cbcCipher.processBlock(data, offset, returnData, offset);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        return returnData;
    }
}

