/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class CipherType
implements Comparable {
    public static final CipherType NULL = new CipherType("NULL");
    public static final CipherType DES = new CipherType("DES");
    public static final CipherType DES3 = new CipherType("DES3");
    public static final CipherType AES128 = new CipherType("AES128");
    private static final CipherType[] values = new CipherType[]{NULL, DES, DES3, AES128};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private static int nextOrdinal = 0;
    private final int ordinal = nextOrdinal++;

    private CipherType(String name) {
        this.name = name;
    }

    public CipherType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (CipherType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NULL;
    }

    public int compareTo(Object that) {
        return this.ordinal - ((CipherType)that).ordinal;
    }

    public String toString() {
        return this.name;
    }
}

