/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.service;

import java.io.UnsupportedEncodingException;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public abstract class DesStringToKey
extends CommandBase {
    public byte[] getKey(String passPhrase) {
        return this.generateKey(passPhrase);
    }

    public byte[] getKey(String password, String realmName, String userName) {
        return this.generateKey(password + realmName + userName);
    }

    private byte[] generateKey(String passPhrase) {
        byte[] encodedByteArray = this.characterEncodeString(passPhrase);
        byte[] paddedByteArray = this.padString(encodedByteArray);
        byte[] secretKey = this.fanFold(paddedByteArray);
        DESParameters.setOddParity((byte[])secretKey);
        if (DESParameters.isWeakKey((byte[])secretKey, (int)0)) {
            secretKey = this.getStrongKey(secretKey);
        }
        secretKey = this.encryptSecretKey(paddedByteArray, secretKey);
        DESParameters.setOddParity((byte[])secretKey);
        if (DESParameters.isWeakKey((byte[])secretKey, (int)0)) {
            secretKey = this.getStrongKey(secretKey);
        }
        return secretKey;
    }

    private byte[] fanFold(byte[] paddedByteArray) {
        byte[] secretKey = new byte[8];
        int div = paddedByteArray.length / 8;
        for (int ii = 0; ii < div; ++ii) {
            int jj;
            byte[] blockValue1 = new byte[8];
            System.arraycopy(paddedByteArray, ii * 8, blockValue1, 0, 8);
            if (ii % 2 == 1) {
                int jj2;
                byte tempbyte1 = 0;
                byte tempbyte2 = 0;
                byte[] blockValue2 = new byte[8];
                for (jj2 = 0; jj2 < 8; ++jj2) {
                    int kk;
                    tempbyte2 = 0;
                    for (kk = 0; kk < 4; ++kk) {
                        tempbyte2 = (byte)(1 << 7 - kk & 0xFF);
                        tempbyte1 = (byte)(tempbyte1 | (blockValue1[jj2] & tempbyte2) >>> 7 - 2 * kk);
                        tempbyte2 = 0;
                    }
                    for (kk = 4; kk < 8; ++kk) {
                        tempbyte2 = (byte)(1 << 7 - kk & 0xFF);
                        tempbyte1 = (byte)(tempbyte1 | (blockValue1[jj2] & tempbyte2) << 2 * kk - 7);
                        tempbyte2 = 0;
                    }
                    blockValue2[7 - jj2] = tempbyte1;
                    tempbyte1 = 0;
                }
                for (jj2 = 0; jj2 < 8; ++jj2) {
                    blockValue2[jj2] = (byte)((blockValue2[jj2] & 0xFF) >>> 1 & 0xFF);
                }
                System.arraycopy(blockValue2, 0, blockValue1, 0, blockValue2.length);
            }
            for (jj = 0; jj < 8; ++jj) {
                blockValue1[jj] = (byte)((blockValue1[jj] & 0xFF) << 1 & 0xFF);
            }
            for (jj = 0; jj < 8; ++jj) {
                int n = jj;
                secretKey[n] = (byte)(secretKey[n] ^ blockValue1[jj]);
            }
        }
        return secretKey;
    }

    private byte[] encryptSecretKey(byte[] data, byte[] key) {
        CBCBlockCipher cipher = new CBCBlockCipher((BlockCipher)new DESEngine());
        KeyParameter kp = new KeyParameter(key);
        ParametersWithIV iv = new ParametersWithIV((CipherParameters)kp, key);
        cipher.init(true, (CipherParameters)iv);
        byte[] encKey = new byte[data.length];
        byte[] ivBytes = new byte[8];
        for (int ii = 0; ii < data.length / 8; ++ii) {
            cipher.processBlock(data, ii * 8, encKey, ii * 8);
            System.arraycopy(encKey, ii * 8, ivBytes, 0, 8);
            iv = new ParametersWithIV((CipherParameters)kp, ivBytes);
            cipher.init(true, (CipherParameters)iv);
        }
        return ivBytes;
    }

    private byte[] getStrongKey(byte[] keyValue) {
        keyValue[7] = (byte)(keyValue[7] ^ 0xF0);
        return keyValue;
    }

    private byte[] characterEncodeString(String str) {
        byte[] encodedByteArray = new byte[str.length()];
        try {
            encodedByteArray = str.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encodedByteArray;
    }

    private byte[] padString(byte[] encodedString) {
        int length = encodedString.length < 8 ? encodedString.length : encodedString.length % 8;
        if (length == 0) {
            return encodedString;
        }
        byte[] paddedByteArray = new byte[8 - length + encodedString.length];
        for (int ii = paddedByteArray.length - 1; ii > encodedString.length - 1; --ii) {
            paddedByteArray[ii] = 0;
        }
        System.arraycopy(encodedString, 0, paddedByteArray, 0, encodedString.length);
        return paddedByteArray;
    }
}

