/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.SamType;

public class PrincipalStoreEntry {
    private String commonName;
    private KerberosPrincipal principal;
    private String realmName;
    private String userId;
    private KerberosTime validStart;
    private KerberosTime validEnd;
    private KerberosTime passwordEnd;
    private int maxLife;
    private int maxRenew;
    private int kdcFlags;
    private SamType samType;
    private EncryptionKey key;

    PrincipalStoreEntry(String commonName, String userId, KerberosPrincipal principal, int keyVersionNumber, KerberosTime validStart, KerberosTime validEnd, KerberosTime passwordEnd, int maxLife, int maxRenew, int kdcFlags, int keyType, byte[] key, String realmName, SamType samType) {
        this.commonName = commonName;
        this.userId = userId;
        this.principal = principal;
        this.validStart = validStart;
        this.validEnd = validEnd;
        this.passwordEnd = passwordEnd;
        this.maxLife = maxLife;
        this.maxRenew = maxRenew;
        this.kdcFlags = kdcFlags;
        this.realmName = realmName;
        this.samType = samType;
        this.key = new EncryptionKey(EncryptionType.getTypeByOrdinal(keyType), key, keyVersionNumber);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getUserId() {
        return this.userId;
    }

    public EncryptionKey getEncryptionKey() {
        return this.key;
    }

    public int getKDCFlags() {
        return this.kdcFlags;
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public int getMaxRenew() {
        return this.maxRenew;
    }

    public KerberosTime getPasswordEnd() {
        return this.passwordEnd;
    }

    public KerberosPrincipal getPrincipal() {
        return this.principal;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public KerberosTime getValidEnd() {
        return this.validEnd;
    }

    public KerberosTime getValidStart() {
        return this.validStart;
    }

    public SamType getSamType() {
        return this.samType;
    }
}

