/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class AuthorizationType
implements Comparable {
    public static final AuthorizationType NULL = new AuthorizationType(0, "null");
    public static final AuthorizationType IF_RELEVANT = new AuthorizationType(1, "if relevant");
    public static final AuthorizationType INTENDED_FOR_SERVER = new AuthorizationType(2, "intended for server");
    public static final AuthorizationType INTENDED_FOR_APPLICATION_CLASS = new AuthorizationType(3, "intended for application class");
    public static final AuthorizationType KDC_ISSUED = new AuthorizationType(4, "kdc issued");
    public static final AuthorizationType OR = new AuthorizationType(5, "or");
    public static final AuthorizationType MANDATORY_TICKET_EXTENSIONS = new AuthorizationType(6, "mandatory ticket extensions");
    public static final AuthorizationType IN_TICKET_EXTENSIONS = new AuthorizationType(7, "in ticket extensions");
    public static final AuthorizationType OSF_DCE = new AuthorizationType(64, "OSF DCE");
    public static final AuthorizationType SESAME = new AuthorizationType(65, "sesame");
    private final String name;
    private final int ordinal;
    private static final AuthorizationType[] values = new AuthorizationType[]{NULL, IF_RELEVANT, INTENDED_FOR_SERVER, INTENDED_FOR_APPLICATION_CLASS, KDC_ISSUED, OR, MANDATORY_TICKET_EXTENSIONS, IN_TICKET_EXTENSIONS, OSF_DCE, SESAME};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }

    public int compareTo(Object that) {
        return this.ordinal - ((AuthorizationType)that).ordinal;
    }

    public static AuthorizationType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (AuthorizationType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    private AuthorizationType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }
}

