/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.util.Strings;

public class KerberosUtils {
    public static final int NULL = -1;
    public static final List<String> EMPTY_PRINCIPAL_NAME = new ArrayList<String>();
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final SimpleDateFormat UTC_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss'Z'");

    public static List<String> getNames(KerberosPrincipal principal) throws ParseException {
        if (principal == null) {
            return EMPTY_PRINCIPAL_NAME;
        }
        String names = principal.getName();
        if (Strings.isEmpty((String)names)) {
            return EMPTY_PRINCIPAL_NAME;
        }
        return KerberosUtils.getNames(names);
    }

    public static List<String> getNames(String principalNames) throws ParseException {
        if (principalNames == null) {
            return EMPTY_PRINCIPAL_NAME;
        }
        ArrayList<String> nameComponents = new ArrayList<String>();
        char[] chars = principalNames.toCharArray();
        boolean escaped = false;
        boolean done = false;
        int start = 0;
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            pos = i;
            switch (chars[i]) {
                case '\\': {
                    escaped = !escaped;
                    break;
                }
                case '/': {
                    String nameComponent;
                    if (escaped) {
                        escaped = false;
                        break;
                    }
                    if (i - start > 0) {
                        nameComponent = new String(chars, start, i - start);
                        nameComponents.add(nameComponent);
                        start = i + 1;
                        break;
                    }
                    throw new ParseException(I18n.err((I18n)I18n.ERR_628, (Object[])new Object[0]), i);
                }
                case '@': {
                    String nameComponent;
                    if (escaped) {
                        escaped = false;
                        break;
                    }
                    done = true;
                    if (i - start > 0) {
                        nameComponent = new String(chars, start, i - start);
                        nameComponents.add(nameComponent);
                        start = i + 1;
                        break;
                    }
                    throw new ParseException(I18n.err((I18n)I18n.ERR_628, (Object[])new Object[0]), i);
                }
            }
            if (done) break;
        }
        if (escaped) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_629, (Object[])new Object[0]), pos);
        }
        return nameComponents;
    }

    public static KerberosPrincipal getKerberosPrincipal(PrincipalName principal, String realm) {
        String name = principal.getNameString();
        if (!Strings.isEmpty((String)realm)) {
            name = name + '@' + realm;
        }
        return new KerberosPrincipal(name, principal.getNameType().getValue());
    }

    public static EncryptionType getBestEncryptionType(List<EncryptionType> requestedTypes, List<EncryptionType> configuredTypes) {
        for (EncryptionType encryptionType : requestedTypes) {
            if (!configuredTypes.contains((Object)encryptionType)) continue;
            return encryptionType;
        }
        return null;
    }

    public static String getEncryptionTypesString(List<EncryptionType> encryptionTypes) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (EncryptionType etype : encryptionTypes) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append((Object)etype);
        }
        return sb.toString();
    }

    public static boolean isKerberosString(byte[] value) {
        if (value == null) {
            return false;
        }
        for (byte b : value) {
            if (b >= 32 && b <= 126) continue;
            return false;
        }
        return true;
    }

    static {
        UTC_DATE_FORMAT.setTimeZone(UTC_TIME_ZONE);
    }
}

