/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import jdbm.RecordManager;
import jdbm.helper.ByteArraySerializer;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.helper.Serializer;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.StringSerializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.UuidSerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndex;
import org.apache.directory.server.xdbm.EmptyIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmIndex<K, V>
extends AbstractIndex<K, V, String> {
    private static final Logger LOG = LoggerFactory.getLogger((String)JdbmIndex.class.getSimpleName());
    public static final int DEFAULT_DUPLICATE_LIMIT = 512;
    public static final String FORWARD_BTREE = "_forward";
    public static final String REVERSE_BTREE = "_reverse";
    protected JdbmTable<K, String> forward;
    protected JdbmTable<String, K> reverse;
    protected RecordManager recMan;
    protected int numDupLimit = 512;
    protected File wkDirPath;

    public JdbmIndex(String attributeId, boolean withReverse) {
        super(attributeId, withReverse);
        this.initialized = false;
    }

    public void init(SchemaManager schemaManager, AttributeType attributeType) throws IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        if (this.wkDirPath == null) {
            NullPointerException e = new NullPointerException("The index working directory has not be set");
            e.printStackTrace();
            throw e;
        }
        String path = new File(this.wkDirPath, attributeType.getOid()).getAbsolutePath();
        BaseRecordManager base = new BaseRecordManager(path);
        this.recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(100));
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        FileWriter fw = new FileWriter(new File(path + "-" + attributeType.getName() + ".txt"));
        fw.write(attributeType.toString());
        fw.close();
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_574, (Object[])new Object[]{this.attributeType.getName()}));
        }
        SerializableComparator comp = new SerializableComparator(mr.getOid());
        UuidComparator.INSTANCE.setSchemaManager(schemaManager);
        comp.setSchemaManager(schemaManager);
        this.forward = mr.getSyntax().isHumanReadable() ? new JdbmTable(schemaManager, this.attributeType.getOid() + FORWARD_BTREE, this.numDupLimit, this.recMan, comp, UuidComparator.INSTANCE, StringSerializer.INSTANCE, UuidSerializer.INSTANCE) : new JdbmTable(schemaManager, this.attributeType.getOid() + FORWARD_BTREE, this.numDupLimit, this.recMan, comp, UuidComparator.INSTANCE, (Serializer)new ByteArraySerializer(), UuidSerializer.INSTANCE);
        if (this.withReverse) {
            this.reverse = this.attributeType.isSingleValued() ? new JdbmTable(schemaManager, this.attributeType.getOid() + REVERSE_BTREE, this.recMan, UuidComparator.INSTANCE, UuidSerializer.INSTANCE, null) : new JdbmTable(schemaManager, this.attributeType.getOid() + REVERSE_BTREE, this.numDupLimit, this.recMan, UuidComparator.INSTANCE, comp, UuidSerializer.INSTANCE, null);
        }
    }

    public int getNumDupLimit() {
        return this.numDupLimit;
    }

    public void setNumDupLimit(int numDupLimit) {
        this.protect("numDupLimit");
        this.numDupLimit = numDupLimit;
    }

    public void setWkDirPath(URI wkDirPath) {
        this.protect("wkDirPath");
        this.wkDirPath = new File(wkDirPath);
    }

    public URI getWkDirPath() {
        return this.wkDirPath != null ? this.wkDirPath.toURI() : null;
    }

    public int count() throws IOException {
        return this.forward.count();
    }

    public int count(K attrVal) throws Exception {
        return this.forward.count(attrVal);
    }

    public int greaterThanCount(K attrVal) throws Exception {
        return this.forward.greaterThanCount(attrVal);
    }

    public int lessThanCount(K attrVal) throws Exception {
        return this.forward.lessThanCount(attrVal);
    }

    public String forwardLookup(K attrVal) throws Exception {
        return this.forward.get(attrVal);
    }

    public K reverseLookup(String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.get(id);
        }
        return null;
    }

    public synchronized void add(K attrVal, String id) throws Exception {
        this.forward.put(attrVal, id);
        if (this.withReverse) {
            this.reverse.put(id, (String)attrVal);
        }
    }

    public synchronized void drop(K attrVal, String id) throws Exception {
        if (this.forward.has(attrVal, id)) {
            this.forward.remove(attrVal, id);
            if (this.withReverse) {
                this.reverse.remove(id, (String)attrVal);
            }
        }
    }

    public void drop(String entryId) throws Exception {
        if (this.withReverse) {
            if (this.isDupsEnabled()) {
                Cursor<Tuple<String, K>> values = this.reverse.cursor(entryId);
                while (values.next()) {
                    this.forward.remove(((Tuple)values.get()).getValue(), entryId);
                }
                values.close();
            } else {
                K key = this.reverse.get(entryId);
                this.forward.remove(key);
            }
            this.reverse.remove(entryId);
        }
    }

    public Cursor<IndexEntry<K, String>> reverseCursor() throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(), false);
        }
        return new EmptyIndexCursor();
    }

    public Cursor<IndexEntry<K, String>> forwardCursor() throws LdapException {
        return new IndexCursorAdaptor(this.forward.cursor(), true);
    }

    public Cursor<IndexEntry<K, String>> reverseCursor(String id) throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(id), false);
        }
        return new EmptyIndexCursor();
    }

    public Cursor<IndexEntry<K, String>> forwardCursor(K key) throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(key), true);
    }

    public Cursor<K> reverseValueCursor(String id) throws Exception {
        if (this.withReverse) {
            return this.reverse.valueCursor(id);
        }
        return new EmptyCursor();
    }

    public Cursor<String> forwardValueCursor(K key) throws Exception {
        return this.forward.valueCursor(key);
    }

    public boolean forward(K attrVal) throws Exception {
        return this.forward.has(attrVal);
    }

    public boolean forward(K attrVal, String id) throws LdapException {
        return this.forward.has(attrVal, id);
    }

    public boolean reverse(String id) throws Exception {
        if (this.withReverse) {
            return this.reverse.has(id);
        }
        return false;
    }

    public boolean reverse(String id, K attrVal) throws Exception {
        return this.forward.has(attrVal, id);
    }

    public boolean forwardGreaterOrEq(K attrVal) throws Exception {
        return this.forward.hasGreaterOrEqual(attrVal);
    }

    public boolean forwardGreaterOrEq(K attrVal, String id) throws Exception {
        return this.forward.hasGreaterOrEqual(attrVal, id);
    }

    public boolean forwardLessOrEq(K attrVal) throws Exception {
        return this.forward.hasLessOrEqual(attrVal);
    }

    public boolean forwardLessOrEq(K attrVal, String id) throws Exception {
        return this.forward.hasLessOrEqual(attrVal, id);
    }

    public boolean reverseGreaterOrEq(String id) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasGreaterOrEqual(id);
        }
        return false;
    }

    public boolean reverseGreaterOrEq(String id, K attrVal) throws LdapException {
        if (this.withReverse) {
            return this.reverse.hasGreaterOrEqual(id, (String)attrVal);
        }
        return false;
    }

    public boolean reverseLessOrEq(String id) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasLessOrEqual(id);
        }
        return false;
    }

    public boolean reverseLessOrEq(String id, K attrVal) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasLessOrEqual(id, (String)attrVal);
        }
        return false;
    }

    public synchronized void close() throws IOException {
        if (this.forward != null) {
            this.forward.close();
        }
        if (this.reverse != null) {
            this.reverse.close();
        }
        this.recMan.commit();
        this.recMan.close();
    }

    public synchronized void sync() throws IOException {
        this.recMan.commit();
    }

    public boolean isDupsEnabled() {
        if (this.withReverse) {
            return this.reverse.isDupsEnabled();
        }
        return false;
    }

    public String toString() {
        return "Index<" + this.attributeId + ">";
    }
}

