/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import jdbm.btree.BTree;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.ArrayTreeCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainerCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyBTreeCursor;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DupsCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG = LoggerFactory.getLogger((String)DupsCursor.class.getSimpleName());
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final JdbmTable<K, V> table;
    private final DupsContainerCursor<K, V> containerCursor;
    private final Tuple<K, DupsContainer<V>> containerTuple = new Tuple();
    private Cursor<V> dupsCursor;
    private final Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public DupsCursor(JdbmTable<K, V> table) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating DupsCursor {}", (Object)this);
        }
        this.table = table;
        this.containerCursor = new DupsContainerCursor<K, V>(table);
        LOG.debug("Created on table {}", table);
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        this.beforeValue(key, null);
    }

    public void beforeValue(K key, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        this.containerCursor.before(new Tuple(key, null));
        if (this.containerCursor.next()) {
            this.containerTuple.setBoth(this.containerCursor.get());
            DupsContainer values = (DupsContainer)this.containerTuple.getValue();
            if (values.isArrayTree()) {
                ArrayTree set = values.getArrayTree();
                this.dupsCursor = new ArrayTreeCursor(set);
            } else {
                BTree tree = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
            }
            if (value == null) {
                return;
            }
            if (this.table.getKeyComparator().compare(this.containerTuple.getKey(), key) == 0) {
                this.dupsCursor.before(value);
            }
            return;
        }
        this.clearValue();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
    }

    public void afterKey(K key) throws Exception {
        this.afterValue(key, null);
    }

    public void afterValue(K key, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (value == null) {
            this.containerCursor.after(new Tuple(key, null));
        } else {
            this.containerCursor.before(new Tuple(key, null));
        }
        if (this.containerCursor.next()) {
            this.containerTuple.setBoth(this.containerCursor.get());
            DupsContainer values = (DupsContainer)this.containerTuple.getValue();
            if (values.isArrayTree()) {
                ArrayTree set = values.getArrayTree();
                this.dupsCursor = new ArrayTreeCursor(set);
            } else {
                BTree tree = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
            }
            if (value == null) {
                return;
            }
            if (this.table.getKeyComparator().compare(this.containerTuple.getKey(), key) == 0) {
                this.dupsCursor.after(value);
            }
            return;
        }
        this.clearValue();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
    }

    public void before(Tuple<K, V> element) throws Exception {
        this.beforeValue(element.getKey(), element.getValue());
    }

    public void after(Tuple<K, V> element) throws Exception {
        this.afterValue(element.getKey(), element.getValue());
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.clearValue();
        this.containerCursor.beforeFirst();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
        this.dupsCursor = null;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.clearValue();
        this.containerCursor.afterLast();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
        this.dupsCursor = null;
    }

    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        this.clearValue();
        this.dupsCursor = null;
        if (this.containerCursor.first()) {
            this.containerTuple.setBoth(this.containerCursor.get());
            DupsContainer values = (DupsContainer)this.containerTuple.getValue();
            if (((DupsContainer)this.containerTuple.getValue()).isArrayTree()) {
                this.dupsCursor = new ArrayTreeCursor(values.getArrayTree());
            } else {
                BTree bt = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(bt, this.table.getValueComparator());
            }
            this.dupsCursor.first();
            this.valueAvailable = true;
            this.returnedTuple.setKey(this.containerTuple.getKey());
            this.returnedTuple.setValue(this.dupsCursor.get());
            return true;
        }
        return false;
    }

    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        this.clearValue();
        this.dupsCursor = null;
        if (this.containerCursor.last()) {
            this.containerTuple.setBoth(this.containerCursor.get());
            DupsContainer values = (DupsContainer)this.containerTuple.getValue();
            if (values.isArrayTree()) {
                ArrayTree set = values.getArrayTree();
                this.dupsCursor = new ArrayTreeCursor(set);
            } else {
                BTree tree = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
            }
            this.dupsCursor.last();
            this.valueAvailable = true;
            this.returnedTuple.setKey(this.containerTuple.getKey());
            this.returnedTuple.setValue(this.dupsCursor.get());
            return true;
        }
        return false;
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (null == this.dupsCursor || !this.dupsCursor.previous()) {
            if (this.dupsCursor != null) {
                this.dupsCursor.close();
            }
            if (this.containerCursor.previous()) {
                this.containerTuple.setBoth(this.containerCursor.get());
                DupsContainer values = (DupsContainer)this.containerTuple.getValue();
                if (values.isArrayTree()) {
                    ArrayTree set = values.getArrayTree();
                    this.dupsCursor = new ArrayTreeCursor(set);
                } else {
                    BTree tree = this.table.getBTree(values.getBTreeRedirect());
                    this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
                }
                this.dupsCursor.afterLast();
                this.dupsCursor.previous();
            } else {
                this.dupsCursor = null;
                return false;
            }
        }
        this.returnedTuple.setKey(this.containerTuple.getKey());
        this.returnedTuple.setValue(this.dupsCursor.get());
        this.valueAvailable = true;
        return true;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (null == this.dupsCursor || !this.dupsCursor.next()) {
            if (this.dupsCursor != null) {
                this.dupsCursor.close();
            }
            if (this.containerCursor.next()) {
                this.containerTuple.setBoth(this.containerCursor.get());
                DupsContainer values = (DupsContainer)this.containerTuple.getValue();
                if (values.isArrayTree()) {
                    ArrayTree set = values.getArrayTree();
                    this.dupsCursor = new ArrayTreeCursor(set);
                } else {
                    BTree tree = this.table.getBTree(values.getBTreeRedirect());
                    this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
                }
                this.dupsCursor.beforeFirst();
                this.dupsCursor.next();
            } else {
                this.dupsCursor = null;
                return false;
            }
        }
        this.returnedTuple.setKey(this.containerTuple.getKey());
        this.returnedTuple.setValue(this.dupsCursor.get());
        this.valueAvailable = true;
        return true;
    }

    public Tuple<K, V> get() throws Exception {
        this.checkNotClosed("get()");
        if (!this.valueAvailable) {
            throw new InvalidCursorPositionException();
        }
        return this.returnedTuple;
    }

    public void close() throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing DupsCursor {}", (Object)this);
        }
        super.close();
        this.containerCursor.close();
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
    }

    public void close(Exception cause) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing DupsCursor {}", (Object)this);
        }
        super.close(cause);
        this.containerCursor.close(cause);
        if (this.dupsCursor != null) {
            this.dupsCursor.close(cause);
        }
    }
}

