/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import jdbm.RecordManager;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.SnapshotRecordManager;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.LongSerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndex;
import org.apache.directory.server.xdbm.EmptyIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.comparators.SerializableComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmIndex<K, O>
extends AbstractIndex<K, O, Long> {
    private static final Logger LOG = LoggerFactory.getLogger((String)JdbmIndex.class.getSimpleName());
    public static final int DEFAULT_DUPLICATE_LIMIT = 512;
    public static final String FORWARD_BTREE = "_forward";
    public static final String REVERSE_BTREE = "_reverse";
    protected JdbmTable<K, Long> forward;
    protected JdbmTable<Long, K> reverse;
    protected RecordManager recMan;
    protected int numDupLimit = 512;
    protected File wkDirPath;

    public JdbmIndex() {
        super(true);
        this.initialized = false;
    }

    public JdbmIndex(String attributeId) {
        super(attributeId, true);
        this.initialized = false;
    }

    public JdbmIndex(String attributeId, boolean withReverse) {
        super(attributeId, withReverse);
        this.initialized = false;
    }

    public void init(SchemaManager schemaManager, AttributeType attributeType) throws IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        if (this.wkDirPath == null) {
            NullPointerException e = new NullPointerException("The index working directory has not be set");
            e.printStackTrace();
            throw e;
        }
        String path = new File(this.wkDirPath, attributeType.getOid()).getAbsolutePath();
        BaseRecordManager base = new BaseRecordManager(path);
        base.disableTransactions();
        this.recMan = new SnapshotRecordManager((RecordManager)base, 100);
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        FileWriter fw = new FileWriter(new File(path + "-" + attributeType.getName() + ".txt"));
        fw.write(attributeType.toString());
        fw.close();
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_574, (Object[])new Object[]{this.attributeType.getName()}));
        }
        SerializableComparator comp = new SerializableComparator(mr.getOid());
        LongComparator.INSTANCE.setSchemaManager(schemaManager);
        comp.setSchemaManager(schemaManager);
        this.forward = new JdbmTable(schemaManager, this.attributeType.getOid() + FORWARD_BTREE, this.numDupLimit, this.recMan, comp, LongComparator.INSTANCE, null, LongSerializer.INSTANCE);
        if (this.withReverse) {
            this.reverse = this.attributeType.isSingleValued() ? new JdbmTable(schemaManager, this.attributeType.getOid() + REVERSE_BTREE, this.recMan, LongComparator.INSTANCE, LongSerializer.INSTANCE, null) : new JdbmTable(schemaManager, this.attributeType.getOid() + REVERSE_BTREE, this.numDupLimit, this.recMan, LongComparator.INSTANCE, comp, LongSerializer.INSTANCE, null);
        }
    }

    public int getNumDupLimit() {
        return this.numDupLimit;
    }

    public void setNumDupLimit(int numDupLimit) {
        this.protect("numDupLimit");
        this.numDupLimit = numDupLimit;
    }

    public void setWkDirPath(URI wkDirPath) {
        this.protect("wkDirPath");
        this.wkDirPath = new File(wkDirPath);
    }

    public URI getWkDirPath() {
        return this.wkDirPath != null ? this.wkDirPath.toURI() : null;
    }

    public int count() throws IOException {
        return this.forward.count();
    }

    public int count(K attrVal) throws Exception {
        return this.forward.count(attrVal);
    }

    public int greaterThanCount(K attrVal) throws Exception {
        return this.forward.greaterThanCount(attrVal);
    }

    public int lessThanCount(K attrVal) throws Exception {
        return this.forward.lessThanCount(attrVal);
    }

    public Long forwardLookup(K attrVal) throws Exception {
        return this.forward.get(attrVal);
    }

    public K reverseLookup(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.get(id);
        }
        return null;
    }

    public synchronized void add(K attrVal, Long id) throws Exception {
        this.forward.put(attrVal, id);
        if (this.withReverse) {
            this.reverse.put(id, (Long)attrVal);
        }
    }

    public synchronized void drop(K attrVal, Long id) throws Exception {
        if (this.forward.has(attrVal, id)) {
            this.forward.remove(attrVal, id);
            if (this.withReverse) {
                this.reverse.remove(id, (Long)attrVal);
            }
        }
    }

    public void drop(Long entryId) throws Exception {
        Cursor<Tuple<Long, K>> values = this.reverse.cursor(entryId);
        while (values.next()) {
            this.forward.remove(((Tuple)values.get()).getValue(), entryId);
        }
        values.close();
        if (this.withReverse) {
            this.reverse.remove(entryId);
        }
    }

    public IndexCursor<K, O, Long> reverseCursor() throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(), false);
        }
        return new EmptyIndexCursor();
    }

    public IndexCursor<K, O, Long> forwardCursor() throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(), true);
    }

    public IndexCursor<K, O, Long> reverseCursor(Long id) throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(id), false);
        }
        return new EmptyIndexCursor();
    }

    public IndexCursor<K, O, Long> forwardCursor(K key) throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(key), true);
    }

    public Cursor<K> reverseValueCursor(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.valueCursor(id);
        }
        return new EmptyCursor();
    }

    public Cursor<Long> forwardValueCursor(K key) throws Exception {
        return this.forward.valueCursor(key);
    }

    public boolean forward(K attrVal) throws Exception {
        return this.forward.has(attrVal);
    }

    public boolean forward(K attrVal, Long id) throws Exception {
        return this.forward.has(attrVal, id);
    }

    public boolean reverse(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.has(id);
        }
        return false;
    }

    public boolean reverse(Long id, K attrVal) throws Exception {
        return this.forward.has(attrVal, id);
    }

    public boolean forwardGreaterOrEq(K attrVal) throws Exception {
        return this.forward.hasGreaterOrEqual(attrVal);
    }

    public boolean forwardGreaterOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasGreaterOrEqual(attrVal, id);
    }

    public boolean forwardLessOrEq(K attrVal) throws Exception {
        return this.forward.hasLessOrEqual(attrVal);
    }

    public boolean forwardLessOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasLessOrEqual(attrVal, id);
    }

    public boolean reverseGreaterOrEq(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasGreaterOrEqual(id);
        }
        return false;
    }

    public boolean reverseGreaterOrEq(Long id, K attrVal) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasGreaterOrEqual(id, (Long)attrVal);
        }
        return false;
    }

    public boolean reverseLessOrEq(Long id) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasLessOrEqual(id);
        }
        return false;
    }

    public boolean reverseLessOrEq(Long id, K attrVal) throws Exception {
        if (this.withReverse) {
            return this.reverse.hasLessOrEqual(id, (Long)attrVal);
        }
        return false;
    }

    public synchronized void close() throws IOException {
        if (this.forward != null) {
            this.forward.close();
        }
        if (this.reverse != null) {
            this.reverse.close();
        }
        this.recMan.commit();
        this.recMan.close();
    }

    public synchronized void sync() throws IOException {
        this.recMan.commit();
    }

    public boolean isDupsEnabled() {
        if (this.withReverse) {
            return this.reverse.isDupsEnabled();
        }
        return false;
    }

    public String toString() {
        return "Index<" + this.attributeId + ">";
    }
}

