/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import jdbm.helper.TupleBrowser;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NoDupsCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final JdbmTable<K, V> table;
    private jdbm.helper.Tuple jdbmTuple = new jdbm.helper.Tuple();
    private Tuple<K, V> returnedTuple = new Tuple();
    private TupleBrowser browser;
    private boolean valueAvailable;

    public NoDupsCursor(JdbmTable<K, V> table) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating NoDupsCursor {}", (Object)this);
        }
        this.table = table;
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.jdbmTuple.setKey(null);
        this.jdbmTuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeKey()");
        this.browser = this.table.getBTree().browse(key);
        this.clearValue();
    }

    public void afterKey(K key) throws LdapException, CursorException, IOException {
        this.browser = this.table.getBTree().browse(key);
        while (this.browser.getNext(this.jdbmTuple)) {
            this.checkNotClosed("afterKey()");
            Object next = this.jdbmTuple.getKey();
            int nextCompared = this.table.getKeyComparator().compare(next, key);
            if (nextCompared <= 0) continue;
            this.browser.getPrevious(this.jdbmTuple);
            this.clearValue();
            return;
        }
        this.clearValue();
    }

    public void beforeValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_596, (Object[])new Object[0]));
    }

    public void afterValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_596, (Object[])new Object[0]));
    }

    public void before(Tuple<K, V> element) throws LdapException, CursorException, IOException {
        this.beforeKey(element.getKey());
    }

    public void after(Tuple<K, V> element) throws LdapException, CursorException, IOException {
        this.afterKey(element.getKey());
    }

    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        this.browser = this.table.getBTree().browse();
        this.clearValue();
    }

    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        this.browser = this.table.getBTree().browse(null);
        this.clearValue();
    }

    public boolean first() throws LdapException, CursorException, IOException {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws LdapException, CursorException, IOException {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.afterLast();
        }
        if (this.browser.getPrevious(this.jdbmTuple)) {
            if (this.returnedTuple.getKey() != null && this.table.getKeyComparator().compare(this.jdbmTuple.getKey(), this.returnedTuple.getKey()) == 0) {
                this.browser.getPrevious(this.jdbmTuple);
            }
            this.returnedTuple.setKey(this.jdbmTuple.getKey());
            this.returnedTuple.setValue(this.jdbmTuple.getValue());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.beforeFirst();
        }
        if (this.browser.getNext(this.jdbmTuple)) {
            if (this.returnedTuple.getKey() != null && this.table.getKeyComparator().compare(this.jdbmTuple.getKey(), this.returnedTuple.getKey()) == 0) {
                this.browser.getNext(this.jdbmTuple);
            }
            this.returnedTuple.setKey(this.jdbmTuple.getKey());
            this.returnedTuple.setValue(this.jdbmTuple.getValue());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public Tuple<K, V> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing NoDupsCursor {}", (Object)this);
        }
        super.close();
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing NoDupsCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

