/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEntrySerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ServerEntrySerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private transient SchemaManager schemaManager;

    public ServerEntrySerializer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public byte[] serialize(Object object) throws IOException {
        DefaultEntry entry = (DefaultEntry)object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        Dn dn = entry.getDn();
        if (dn.isEmpty()) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            Rdn rdn = dn.getRdn();
            rdn.writeExternal((ObjectOutput)out);
        }
        out.writeInt(entry.getAttributeTypes().size());
        for (AttributeType attributeType : entry.getAttributeTypes()) {
            String oid = attributeType.getOid();
            out.writeUTF(oid);
            Attribute attribute = entry.get(attributeType);
            attribute.writeExternal((ObjectOutput)out);
        }
        out.flush();
        if (IS_DEBUG) {
            LOG.debug(">------------------------------------------------");
            LOG.debug("Serialize " + entry);
        }
        return baos.toByteArray();
    }

    public Object deserialize(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            DefaultEntry entry = new DefaultEntry(this.schemaManager);
            byte hasDn = in.readByte();
            if (hasDn == 1) {
                Rdn rdn = new Rdn(this.schemaManager);
                rdn.readExternal((ObjectInput)in);
                try {
                    entry.setDn(new Dn(this.schemaManager, new Rdn[]{rdn}));
                }
                catch (LdapInvalidDnException lide) {
                    IOException ioe = new IOException(lide.getMessage());
                    ioe.initCause(lide);
                    throw ioe;
                }
            } else {
                entry.setDn(Dn.EMPTY_DN);
            }
            int nbAttributes = in.readInt();
            for (int i = 0; i < nbAttributes; ++i) {
                String oid = in.readUTF();
                try {
                    AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
                    DefaultAttribute attribute = new DefaultAttribute(attributeType);
                    attribute.readExternal((ObjectInput)in);
                    entry.add(new Attribute[]{attribute});
                    continue;
                }
                catch (LdapException ne) {
                    throw new ClassNotFoundException(ne.getMessage(), ne);
                }
            }
            return entry;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err((I18n)I18n.ERR_134, (Object[])new Object[]{cnfe.getLocalizedMessage()}));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }
}

