/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.server.installers.Target;
import org.apache.directory.server.installers.archive.ArchiveInstallerCommand;
import org.apache.directory.server.installers.archive.ArchiveTarget;
import org.apache.directory.server.installers.bin.BinInstallerCommand;
import org.apache.directory.server.installers.bin.BinTarget;
import org.apache.directory.server.installers.deb.DebInstallerCommand;
import org.apache.directory.server.installers.deb.DebTarget;
import org.apache.directory.server.installers.macosxpkg.MacOsXPkgInstallerCommand;
import org.apache.directory.server.installers.macosxpkg.MacOsXPkgTarget;
import org.apache.directory.server.installers.nsis.NsisInstallerCommand;
import org.apache.directory.server.installers.nsis.NsisTarget;
import org.apache.directory.server.installers.rpm.RpmInstallerCommand;
import org.apache.directory.server.installers.rpm.RpmTarget;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/installers")
    private File outputDirectory;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private RpmTarget[] rpmTargets;
    @Parameter
    private MacOsXPkgTarget[] macOsXPkgTargets;
    @Parameter
    private NsisTarget[] nsisTargets;
    @Parameter
    private DebTarget[] debTargets;
    @Parameter
    private BinTarget[] binTargets;
    @Parameter
    private ArchiveTarget[] archiveTargets;
    @Parameter(property="installers.dpkg", defaultValue="/usr/bin/dpkg")
    private File dpkgUtility;
    @Parameter(property="installers.packageMaker", defaultValue="/Developer/Applications/Utilities/PackageMaker.app/Contents/MacOS/PackageMaker")
    private File packageMakerUtility;
    @Parameter(property="installers.makensis", defaultValue="/usr/bin/makensis")
    private File makensisUtility;
    @Parameter(property="installers.rpmbuild", defaultValue="/usr/bin/rpmbuild")
    private File rpmbuildUtility;
    private List<Target> allTargets = new ArrayList<Target>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.collectAllTargets();
        if (this.allTargets.isEmpty()) {
            this.getLog().info((CharSequence)"No installers to generate.");
            return;
        }
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)("Creating the putput directory : " + this.outputDirectory.getAbsolutePath()));
        FileUtils.mkdir((String)this.outputDirectory.getAbsolutePath());
        for (Target target : this.allTargets) {
            this.getLog().info((CharSequence)("Executing target '" + target.getId() + "'"));
            this.getLog().info((CharSequence)"--------------------");
            this.getLog().info((CharSequence)("OS Name: " + target.getOsName()));
            this.getLog().info((CharSequence)("OS Arch: " + target.getOsArch()));
            this.getLog().info((CharSequence)"--------------------");
            if (target instanceof ArchiveTarget) {
                ArchiveInstallerCommand archiveCmd = new ArchiveInstallerCommand(this, (ArchiveTarget)target);
                archiveCmd.execute();
            }
            if (target instanceof BinTarget) {
                BinInstallerCommand binCmd = new BinInstallerCommand(this, (BinTarget)target);
                binCmd.execute();
            }
            if (target instanceof DebTarget) {
                DebInstallerCommand debCmd = new DebInstallerCommand(this, (DebTarget)target);
                debCmd.execute();
            }
            if (target instanceof MacOsXPkgTarget) {
                MacOsXPkgInstallerCommand pkgCmd = new MacOsXPkgInstallerCommand(this, (MacOsXPkgTarget)target);
                pkgCmd.execute();
            }
            if (target instanceof NsisTarget) {
                NsisInstallerCommand nsisCmd = new NsisInstallerCommand(this, (NsisTarget)target);
                nsisCmd.execute();
            }
            if (target instanceof RpmTarget) {
                RpmInstallerCommand rpmCmd = new RpmInstallerCommand(this, (RpmTarget)target);
                rpmCmd.execute();
            }
            this.getLog().info((CharSequence)"-------------------------------------------------------");
        }
    }

    private void collectAllTargets() {
        this.addAllTargets(this.allTargets, this.nsisTargets);
        this.addAllTargets(this.allTargets, this.rpmTargets);
        this.addAllTargets(this.allTargets, this.debTargets);
        this.addAllTargets(this.allTargets, this.macOsXPkgTargets);
        this.addAllTargets(this.allTargets, this.binTargets);
        this.addAllTargets(this.allTargets, this.archiveTargets);
    }

    private void addAllTargets(List<Target> list, Target[] array) {
        if (list != null && array != null) {
            list.addAll(Arrays.asList(array));
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getDpkgUtility() {
        return this.dpkgUtility;
    }

    public File getPackageMakerUtility() {
        return this.packageMakerUtility;
    }

    public File getMakensisUtility() {
        return this.makensisUtility;
    }

    public File getRpmbuildUtility() {
        return this.rpmbuildUtility;
    }
}

