/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.rpm;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.LinuxInstallerCommand;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.rpm.RpmTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public class RpmInstallerCommand
extends LinuxInstallerCommand<RpmTarget> {
    private static final String DOT_RPM = ".rpm";
    private static final String APACHEDS_SPEC_FILE = "apacheds.spec";
    private static final String RPMS = "RPMS";
    private static final String SOURCES = "SOURCES";
    private static final String SPECS = "SPECS";
    private static final String BUILD = "BUILD";
    private static final String SRPMS = "SRPMS";

    public RpmInstallerCommand(GenerateMojo mojo, RpmTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        this.log.info((CharSequence)"  Creating Rpm installer...");
        if (!this.getTargetDirectory().mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, (Object[])new Object[]{this.getTargetDirectory()}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        this.log.info((CharSequence)"    Copying Rpm installer files");
        try {
            File rpmBuild = new File(this.getTargetDirectory(), BUILD);
            if (!rpmBuild.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, (Object[])new Object[]{rpmBuild}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            File rpmRpms = new File(this.getTargetDirectory(), RPMS);
            if (!rpmRpms.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, (Object[])new Object[]{rpmRpms}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            File rpmSources = new File(this.getTargetDirectory(), SOURCES);
            if (!rpmSources.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, (Object[])new Object[]{rpmSources}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            File rpmSpecs = new File(this.getTargetDirectory(), SPECS);
            if (!rpmSpecs.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, (Object[])new Object[]{rpmSpecs}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            File rpmSrpms = new File(this.getTargetDirectory(), SRPMS);
            if (!rpmSrpms.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, (Object[])new Object[]{rpmSrpms}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            this.createLayouts();
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/etc-initd-script", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/etc-initd-script"), new File(this.getAdsSourcesDirectory(), "etc-initd-script"), true);
            this.createSpecFile();
            MojoHelperUtils.exec(new String[]{"tar", "-zcf", "apacheds-" + this.getVersion() + ".tar.gz", "apacheds-" + this.getVersion()}, new File(this.getTargetDirectory(), "/SOURCES"), false);
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy Rpm installer files.");
        }
        this.log.info((CharSequence)"    Generating Rpm installer");
        MojoHelperUtils.exec(new String[]{this.mojo.getRpmbuildUtility().getAbsolutePath(), "--quiet", "-ba", "--target", ((RpmTarget)this.target).getOsArch() + "-linux", "--define", "_topdir " + this.getTargetDirectory(), "--define", "_tmppath /tmp", "SPECS/apacheds.spec"}, this.getTargetDirectory(), false);
        try {
            String rpmName = "apacheds-" + this.getVersion() + "-1." + ((RpmTarget)this.target).getOsArch() + DOT_RPM;
            String finalName = ((RpmTarget)this.target).getFinalName();
            if (!finalName.endsWith(DOT_RPM)) {
                finalName = finalName + DOT_RPM;
            }
            File finalFile = new File(this.mojo.getOutputDirectory(), finalName);
            FileUtils.copyFile((File)new File(this.getTargetDirectory(), "RPMS/" + ((RpmTarget)this.target).getOsArch() + "/" + rpmName), (File)finalFile);
            this.log.info((CharSequence)("=> RPM generated at " + finalFile));
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy generated Rpm installer file.");
        }
    }

    private boolean verifyTarget() {
        if (!((RpmTarget)this.target).isOsNameLinux()) {
            this.log.warn((CharSequence)"Rpm installer can only be targeted for Linux platforms!");
            this.log.warn((CharSequence)"The build will continue, but please check the the platform of this installer target");
            return false;
        }
        String osName = System.getProperty("os.name");
        if (!"Linux".equalsIgnoreCase(osName) && !"Mac OS X".equalsIgnoreCase(osName)) {
            this.log.warn((CharSequence)"Rpm package installer can only be built on a machine running Linux or Mac OS X!");
            this.log.warn((CharSequence)"The build will continue, generation of this target is skipped.");
            return false;
        }
        if (!this.mojo.getRpmbuildUtility().exists()) {
            this.log.warn((CharSequence)("Cannot find rpmbuild utility at this location: " + this.mojo.getRpmbuildUtility()));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your rpmbuild utility.");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
        this.filterProperties.put("installation.directory", "/opt/apacheds-" + this.getVersion());
        this.filterProperties.put("instances.directory", "/var/lib/apacheds-" + this.getVersion());
        this.filterProperties.put("default.instance.name", "default");
        this.filterProperties.put("user", "apacheds");
        this.filterProperties.put("group", "apacheds");
        this.filterProperties.put("wrapper.java.command", "# wrapper.java.command=<path-to-java-executable>");
        this.filterProperties.put("double.quote", "");
        this.filterProperties.put("version", this.getVersion());
    }

    private void createSpecFile() throws IOException {
        StringBuilder installLibs = new StringBuilder();
        StringBuilder filesLibs = new StringBuilder();
        File libDirectory = this.getInstallationLayout().getLibDirectory();
        if (libDirectory.exists()) {
            for (File file : libDirectory.listFiles()) {
                if (!file.isFile()) continue;
                installLibs.append("install -m 644 " + this.getBuidDirectory() + "/%{name}-%{version}/server/lib/" + file.getName() + " $RPM_BUILD_ROOT%{adshome}/lib/" + file.getName() + "\n");
                filesLibs.append("%{adshome}/lib/" + file.getName() + "\n");
            }
        }
        Properties properties = new Properties();
        properties.put("version", this.getVersion());
        properties.put("build.dir", this.getBuidDirectory());
        properties.put("install.libs", installLibs.toString());
        properties.put("files.libs", filesLibs.toString());
        MojoHelperUtils.copyAsciiFile(this.mojo, properties, APACHEDS_SPEC_FILE, this.getClass().getResourceAsStream(APACHEDS_SPEC_FILE), new File(this.getTargetDirectory(), "SPECS/apacheds.spec"), true);
    }

    private File getAdsSourcesDirectory() {
        return new File(this.getTargetDirectory(), "SOURCES/apacheds-" + this.getVersion());
    }

    @Override
    public File getInstallationDirectory() {
        return new File(this.getAdsSourcesDirectory(), "server");
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getAdsSourcesDirectory(), "instances/default");
    }

    private String getVersion() {
        return this.mojo.getProject().getVersion().replace('-', '_');
    }

    private String getBuidDirectory() {
        return this.getTargetDirectory().getAbsolutePath() + "/" + BUILD;
    }
}

