/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.macosxpkg;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.installers.AbstractMojoCommand;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.macosxpkg.MacOsXPkgTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Execute;

public class MacOsXPkgInstallerCommand
extends AbstractMojoCommand<MacOsXPkgTarget> {
    private File hdiutilUtility = new File("/usr/bin/hdiutil");

    public MacOsXPkgInstallerCommand(GenerateMojo mojo, MacOsXPkgTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        this.log.info((CharSequence)"  Creating Mac OS X PKG installer...");
        File targetDirectory = this.getTargetDirectory();
        targetDirectory.mkdirs();
        this.log.info((CharSequence)"    Copying PKG installer files");
        File pkgRootDirectory = new File(targetDirectory, "root");
        pkgRootDirectory.mkdirs();
        File pkgRootUsrBinDirectory = new File(pkgRootDirectory, "usr/bin");
        pkgRootUsrBinDirectory.mkdirs();
        File pkgRootUsrLocalApachedsDirectory = new File(pkgRootDirectory, "usr/local/apacheds-" + this.mojo.getProject().getVersion());
        pkgRootUsrLocalApachedsDirectory.mkdirs();
        File pkgRootInstancesDirectory = new File(pkgRootUsrLocalApachedsDirectory, "instances");
        pkgRootInstancesDirectory.mkdirs();
        File pkgRootInstancesDefaultDirectory = new File(pkgRootInstancesDirectory, "default");
        pkgRootInstancesDefaultDirectory.mkdirs();
        File pkgRootInstancesDefaultConfDirectory = new File(pkgRootInstancesDefaultDirectory, "conf");
        pkgRootInstancesDefaultConfDirectory.mkdirs();
        new File(pkgRootInstancesDefaultDirectory, "log").mkdirs();
        new File(pkgRootInstancesDefaultDirectory, "partitions").mkdirs();
        new File(pkgRootInstancesDefaultDirectory, "run").mkdirs();
        File pkgRootLibraryLaunchDaemons = new File(pkgRootDirectory, "Library/LaunchDaemons");
        pkgRootLibraryLaunchDaemons.mkdirs();
        try {
            this.createLayouts();
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("apacheds-usr-bin.sh"), new File(pkgRootUsrBinDirectory, "apacheds"), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("org.apache.directory.server.plist"), new File(pkgRootLibraryLaunchDaemons, "org.apache.directory.server.plist"), true);
            File pkgResourcesEnglishDirectory = new File(targetDirectory, "Resources/en.lproj");
            pkgResourcesEnglishDirectory.mkdirs();
            File pkgScriptsDirectory = new File(targetDirectory, "scripts");
            pkgScriptsDirectory.mkdirs();
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("pkg-background.tiff"), new File(pkgResourcesEnglishDirectory, "background.tiff"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("License.rtf"), new File(pkgResourcesEnglishDirectory, "License.rtf"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("Info.plist"), new File(targetDirectory, "Info.plist"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("postflight"), new File(pkgScriptsDirectory, "postflight"));
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy PKG resources files.");
        }
        this.log.info((CharSequence)"    Generating Mac OS X PKG Installer");
        Execute createPkgTask = new Execute();
        String[] cmd = new String[]{this.mojo.getPackageMakerUtility().getAbsolutePath(), "--root", "root/", "--resources", "Resources/", "--info", "Info.plist", "--title", "Apache Directory Server " + this.mojo.getProject().getVersion(), "--version", this.mojo.getProject().getVersion(), "--scripts", "scripts", "--out", "Apache Directory Server Installer.pkg"};
        createPkgTask.setCommandline(cmd);
        createPkgTask.setWorkingDirectory(targetDirectory);
        try {
            createPkgTask.execute();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed while trying to generate the PKG: " + e.getMessage());
        }
        this.log.info((CharSequence)"  Creating Mac OS X DMG...");
        File dmgDirectory = new File(this.mojo.getOutputDirectory(), ((MacOsXPkgTarget)this.target).getId() + "-dmg");
        dmgDirectory.mkdirs();
        this.log.info((CharSequence)"    Copying DMG files");
        File dmgDmgBackgroundDirectory = new File(dmgDirectory, "dmg/.background");
        dmgDmgBackgroundDirectory.mkdirs();
        try {
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("dmg-background.png"), new File(dmgDirectory, "dmg/.background/background.png"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("DS_Store"), new File(dmgDirectory, "dmg/.DS_Store"));
            MojoHelperUtils.copyFiles(new File(targetDirectory, "Apache Directory Server Installer.pkg"), new File(dmgDirectory, "dmg/Apache Directory Server Installer.pkg"));
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy DMG resources files.");
        }
        MojoHelperUtils.exec(new String[]{"chmod", "755", new File(dmgDirectory, "dmg/Apache Directory Server Installer.pkg/Contents/Resources/postflight").toString()}, dmgDirectory, false);
        this.log.info((CharSequence)"    Generating Mac OS X DMG Installer");
        String finalName = ((MacOsXPkgTarget)this.target).getFinalName();
        if (!finalName.endsWith(".dmg")) {
            finalName = finalName + ".dmg";
        }
        try {
            Execute createDmgTask = new Execute();
            createDmgTask.setCommandline(new String[]{this.hdiutilUtility.getAbsolutePath(), "makehybrid", "-quiet", "-hfs", "-hfs-volume-name", "Apache Directory Server Installer", "-hfs-openfolder", "dmg/", "dmg/", "-o", "TMP.dmg"});
            createDmgTask.setWorkingDirectory(dmgDirectory);
            createDmgTask.execute();
            createDmgTask.setCommandline(new String[]{this.hdiutilUtility.getAbsolutePath(), "convert", "-quiet", "-format", "UDZO", "TMP.dmg", "-o", "../" + finalName});
            createDmgTask.execute();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed while trying to generate the DMG: " + e.getMessage());
        }
        this.log.info((CharSequence)("=> Mac OS X DMG generated at " + new File(this.mojo.getOutputDirectory(), finalName)));
    }

    private boolean verifyTarget() {
        if (!((MacOsXPkgTarget)this.target).getOsName().equalsIgnoreCase("Mac OS X")) {
            this.log.warn((CharSequence)"Mac OS X PKG installer can only be targeted for Mac OS X platform!");
            this.log.warn((CharSequence)"The build will continue, but please check the platform of this installer target.");
            return false;
        }
        if (!"Mac OS X".equalsIgnoreCase(System.getProperty("os.name"))) {
            this.log.warn((CharSequence)"Mac OS X PKG installer can only be built on a machine running Mac OS X!");
            this.log.warn((CharSequence)"The build will continue, generation of this target is skipped.");
            return false;
        }
        if (!this.mojo.getPackageMakerUtility().exists()) {
            this.log.warn((CharSequence)("Cannot find 'PackageMaker' utility at this location: " + this.mojo.getPackageMakerUtility()));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your 'Package Maker' utility.");
            return false;
        }
        if (!this.hdiutilUtility.exists()) {
            this.log.warn((CharSequence)("Cannot find 'hdiutil' utility at this location: " + this.hdiutilUtility));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your 'hdiutil' utility.");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
        this.filterProperties.put("installation.directory", "/usr/local/apacheds-" + this.mojo.getProject().getVersion());
        this.filterProperties.put("instances.directory", "/usr/local/apacheds-" + this.mojo.getProject().getVersion() + "/instances");
        this.filterProperties.put("user", "root");
        this.filterProperties.put("wrapper.java.command", "# wrapper.java.command=<path-to-java-executable>");
        this.filterProperties.put("double.quote", "");
    }

    @Override
    public File getInstallationDirectory() {
        return new File(this.getTargetDirectory(), "root/usr/local/apacheds-" + this.mojo.getProject().getVersion());
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getInstallationDirectory(), "instances/default");
    }
}

