/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.directory.server.InstallationLayout;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.ReflectionProperties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Execute;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class MojoHelperUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBinaryFile(InputStream from, File to) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(to);
            IOUtil.copy((InputStream)from, (OutputStream)out);
        }
        finally {
            IOUtil.close((InputStream)from);
            IOUtil.close((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAsciiFile(GenerateMojo mymojo, Properties filterProperties, InputStream from, File to, boolean filtering) throws IOException {
        BufferedReader fileReader = null;
        OutputStreamWriter fileWriter = null;
        try {
            fileReader = new BufferedReader(new InputStreamReader(from));
            fileWriter = new OutputStreamWriter(new FileOutputStream(to));
            BufferedReader reader = null;
            if (filtering) {
                reader = new InterpolationFilterReader((Reader)fileReader, (Map)filterProperties, "_${", "}");
                reader = new InterpolationFilterReader((Reader)reader, (Map)filterProperties, "${", "}");
                reader = new InterpolationFilterReader((Reader)reader, (Map)filterProperties, "@", "@");
                boolean isPropertiesFile = false;
                if (to.isFile() && to.getName().endsWith(".properties")) {
                    isPropertiesFile = true;
                }
                reader = new InterpolationFilterReader((Reader)reader, (Map)new ReflectionProperties(mymojo.getProject(), isPropertiesFile), "${", "}");
            } else {
                reader = fileReader;
            }
            IOUtil.copy((Reader)reader, (Writer)fileWriter);
        }
        catch (Throwable throwable) {
            IOUtil.close(fileReader);
            IOUtil.close(fileWriter);
            throw throwable;
        }
        IOUtil.close((Reader)fileReader);
        IOUtil.close((Writer)fileWriter);
    }

    public static void copyAsciiFile(GenerateMojo mymojo, Properties filterProperties, File from, File to, boolean filtering) throws IOException {
        MojoHelperUtils.copyAsciiFile(mymojo, filterProperties, new FileInputStream(from), to, filtering);
    }

    public static void copyDependencies(GenerateMojo mymojo, InstallationLayout layout) throws MojoFailureException {
        MojoHelperUtils.copyDependencies(mymojo, layout, true);
    }

    public static void copyDependencies(GenerateMojo mymojo, InstallationLayout layout, boolean includeWrapperDependencies) throws MojoFailureException {
        HashSet<String> excludes = new HashSet<String>();
        if (mymojo.getExcludes() != null) {
            excludes.addAll(mymojo.getExcludes());
        }
        if (!includeWrapperDependencies) {
            excludes.add("org.apache.directory.server:apacheds-wrapper");
            excludes.add("tanukisoft:wrapper");
        }
        for (Artifact artifact : mymojo.getProject().getRuntimeArtifacts()) {
            String key = artifact.getGroupId() + ":" + artifact.getArtifactId();
            if (excludes.contains(key)) continue;
            try {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)layout.getLibDirectory());
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to copy dependency artifact " + artifact + " into position " + layout.getLibDirectory());
            }
        }
    }

    public static void exec(String[] cmd, File workDir, boolean doSudo) throws MojoFailureException {
        String cmdString;
        Execute task = new Execute();
        task.setCommandline(cmd);
        task.setWorkingDirectory(workDir);
        if (doSudo) {
            cmdString = " ";
            for (int ii = 0; ii < cmd.length; ++ii) {
                cmdString = cmdString + cmd[ii] + " ";
            }
            String[] temp = new String[]{"sudo", cmdString};
            cmd = temp;
        }
        cmdString = " ";
        for (int ii = 0; ii < cmd.length; ++ii) {
            cmdString = cmdString + cmd[ii] + " ";
        }
        try {
            task.execute();
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed while trying to execute '" + cmdString + "': " + e.getMessage());
        }
        if (task.getExitValue() != 0) {
            throw new MojoFailureException("Execution of '" + cmdString + "' resulted in a non-zero exit value: " + task.getExitValue());
        }
    }

    public static void copyFiles(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            File[] files = src.listFiles();
            dest.mkdirs();
            for (File file : files) {
                MojoHelperUtils.copyFiles(file, new File(dest, file.getName()));
            }
        } else {
            FileUtils.copyFile((File)src, (File)dest);
        }
    }
}

