/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.directory.server.InstallationLayout;
import org.apache.directory.server.core.InstanceLayout;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.Target;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractMojoCommand<T extends Target> {
    protected Properties filterProperties = new Properties(System.getProperties());
    protected GenerateMojo mojo;
    protected T target;
    protected Log log;

    public AbstractMojoCommand(GenerateMojo mojo, T target) {
        this.mojo = mojo;
        this.target = target;
        this.log = mojo.getLog();
        this.initializeFilterProperties();
    }

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    public Properties getFilterProperties() {
        return this.filterProperties;
    }

    protected void initializeFilterProperties() {
        this.filterProperties.putAll((Map<?, ?>)this.mojo.getProject().getProperties());
    }

    public abstract File getInstallationDirectory();

    public abstract File getInstanceDirectory();

    protected File getTargetDirectory() {
        return new File(this.mojo.getOutputDirectory(), ((Target)this.target).getId());
    }

    public void createLayouts() throws MojoFailureException, IOException {
        this.createLayouts(true);
    }

    public void createLayouts(boolean includeWrapperDependencies) throws MojoFailureException, IOException {
        this.createInstallationLayout(includeWrapperDependencies);
        this.createInstanceLayout();
    }

    protected void createInstallationLayout() throws MojoFailureException, IOException {
        this.createInstallationLayout(true);
    }

    protected void createInstallationLayout(boolean includeWrapperDependencies) throws MojoFailureException, IOException {
        InstallationLayout installationLayout = this.getInstallationLayout();
        installationLayout.mkdirs();
        MojoHelperUtils.copyDependencies(this.mojo, installationLayout, includeWrapperDependencies);
        MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/LICENSE"), new File(installationLayout.getInstallationDirectory(), "LICENSE"));
        MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/NOTICE"), new File(installationLayout.getInstallationDirectory(), "NOTICE"));
        if (((Target)this.target).isOsNameLinux() || ((Target)this.target).isOsNameSolaris() || ((Target)this.target).isOsNameMacOSX()) {
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/apacheds"), new File(installationLayout.getBinDirectory(), "apacheds"), true);
            MojoHelperUtils.exec(new String[]{"chmod", "755", "apacheds"}, installationLayout.getBinDirectory(), false);
        }
        this.copyWrapperFiles();
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper-installation.conf"), new File(installationLayout.getConfDirectory(), "wrapper.conf"), true);
    }

    protected void createInstanceLayout() throws IOException {
        InstanceLayout instanceLayout = this.getInstanceLayout();
        instanceLayout.mkdirs();
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/log4j.properties"), new File(instanceLayout.getConfDirectory(), "log4j.properties"), true);
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper-instance.conf"), new File(instanceLayout.getConfDirectory(), "wrapper.conf"), true);
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/config.ldif"), new File(instanceLayout.getConfDirectory(), "config.ldif"), false);
    }

    protected InstallationLayout getInstallationLayout() {
        return new InstallationLayout(this.getInstallationDirectory());
    }

    protected InstanceLayout getInstanceLayout() {
        return new InstanceLayout(this.getInstanceDirectory());
    }

    private void copyWrapperFiles() throws MojoFailureException {
        try {
            if (((Target)this.target).isOsNameMacOSX() && ((Target)this.target).isOsArchx86()) {
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/bin/wrapper-macosx-universal-32"), new File(this.getInstallationLayout().getBinDirectory(), "wrapper"));
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/lib/libwrapper-macosx-universal-32.jnilib"), new File(this.getInstallationLayout().getLibDirectory(), "libwrapper.jnilib"));
            }
            if (((Target)this.target).isOsNameMacOSX() && ((Target)this.target).isOsArchX86_64()) {
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/bin/wrapper-macosx-universal-64"), new File(this.getInstallationLayout().getBinDirectory(), "wrapper"));
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/lib/libwrapper-macosx-universal-64.jnilib"), new File(this.getInstallationLayout().getLibDirectory(), "libwrapper.jnilib"));
            }
            if (((Target)this.target).isOsNameLinux() && (((Target)this.target).isOsArchI386() || ((Target)this.target).isOsArchx86())) {
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/bin/wrapper-linux-x86-32"), new File(this.getInstallationLayout().getBinDirectory(), "wrapper"));
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/lib/libwrapper-linux-x86-32.so"), new File(this.getInstallationLayout().getLibDirectory(), "libwrapper.so"));
            }
            if (((Target)this.target).isOsNameLinux() && (((Target)this.target).isOsArchX86_64() || ((Target)this.target).isOsArchAmd64())) {
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/bin/wrapper-linux-x86-64"), new File(this.getInstallationLayout().getBinDirectory(), "wrapper"));
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/lib/libwrapper-linux-x86-64.so"), new File(this.getInstallationLayout().getLibDirectory(), "libwrapper.so"));
            }
            if (((Target)this.target).isOsNameSolaris() && ((Target)this.target).isOsArchx86()) {
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/bin/wrapper-solaris-x86-32"), new File(this.getInstallationLayout().getBinDirectory(), "wrapper"));
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/lib/libwrapper-solaris-x86-32.so"), new File(this.getInstallationLayout().getLibDirectory(), "libwrapper.so"));
            }
            if (((Target)this.target).isOsNameSolaris() && ((Target)this.target).isOsArchSparc()) {
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/bin/wrapper-solaris-sparc-32"), new File(this.getInstallationLayout().getBinDirectory(), "wrapper"));
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/lib/libwrapper-solaris-sparc-32.so"), new File(this.getInstallationLayout().getLibDirectory(), "libwrapper.so"));
            }
            if (((Target)this.target).isOsNameWindows()) {
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/bin/wrapper-windows-x86-32.exe"), new File(this.getInstallationLayout().getBinDirectory(), "wrapper.exe"));
                MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/lib/wrapper-windows-x86-32.dll"), new File(this.getInstallationLayout().getLibDirectory(), "wrapper.dll"));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy Tanuki binary files to lib and bin directories");
        }
    }
}

