/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.nsis;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.installers.AbstractMojoCommand;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.nsis.NsisTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Execute;

public class NsisInstallerCommand
extends AbstractMojoCommand<NsisTarget> {
    private static final String WRAPPER_EXE_RESOURCE = "/org/apache/directory/server/installers/wrapper/bin/wrapper-windows-x86-32.exe";
    private static final String WRAPPER_EXE_FILE = "wrapper.exe";
    private static final String WRAPPER_DLL_RESOURCE = "/org/apache/directory/server/installers/wrapper/lib/wrapper-windows-x86-32.dll";
    private static final String WRAPPER_DLL_FILE = "wrapper.dll";
    private static final String MANAGE_APACHEDS_EXE = "Manage ApacheDS.exe";
    private static final String HEADER_BMP = "header.bmp";
    private static final String WELCOME_BMP = "welcome.bmp";
    private static final String INSTALLER_ICO = "installer.ico";
    private static final String UNINSTALLER_ICO = "uninstaller.ico";
    private static final String INSTALLER_NSI = "installer.nsi";
    private static final String EXE_EXTENSION = ".exe";
    private static final String INSTALLATION_FILES = "installationFiles";
    private static final String INSTANCES_FILES = "instancesFiles";

    public NsisInstallerCommand(GenerateMojo mojo, NsisTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        this.log.info((CharSequence)"  Creating NSIS installer...");
        File targetDirectory = this.getTargetDirectory();
        if (!targetDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{targetDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        this.log.info((CharSequence)"    Copying NSIS installer files");
        File installerFile = new File(targetDirectory, INSTALLER_NSI);
        try {
            this.createLayouts();
            MojoHelperUtils.copyBinaryFile(this.mojo, MANAGE_APACHEDS_EXE, this.getClass().getResourceAsStream(MANAGE_APACHEDS_EXE), new File(this.getInstallationDirectory(), MANAGE_APACHEDS_EXE));
            MojoHelperUtils.copyBinaryFile(this.mojo, HEADER_BMP, this.getClass().getResourceAsStream(HEADER_BMP), new File(targetDirectory, HEADER_BMP));
            MojoHelperUtils.copyBinaryFile(this.mojo, WELCOME_BMP, this.getClass().getResourceAsStream(WELCOME_BMP), new File(targetDirectory, WELCOME_BMP));
            MojoHelperUtils.copyBinaryFile(this.mojo, INSTALLER_ICO, this.getClass().getResourceAsStream(INSTALLER_ICO), new File(targetDirectory, INSTALLER_ICO));
            MojoHelperUtils.copyBinaryFile(this.mojo, UNINSTALLER_ICO, this.getClass().getResourceAsStream(UNINSTALLER_ICO), new File(targetDirectory, UNINSTALLER_ICO));
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, INSTALLER_NSI, this.getClass().getResourceAsStream(INSTALLER_NSI), installerFile, true);
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy NSIS installer files.");
        }
        this.log.info((CharSequence)"    Generating NSIS installer");
        Execute createPkgTask = new Execute();
        String[] cmd = new String[]{this.mojo.getMakensisUtility().getAbsolutePath(), "-V2", installerFile.getAbsolutePath()};
        createPkgTask.setCommandline(cmd);
        createPkgTask.setWorkingDirectory(targetDirectory);
        try {
            createPkgTask.execute();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed while trying to generate the NSIS installer: " + e.getMessage());
        }
        this.log.info((CharSequence)("=> NSIS installer generated at " + new File(this.mojo.getOutputDirectory(), this.filterProperties.getProperty("finalName"))));
    }

    private boolean verifyTarget() {
        if (!((NsisTarget)this.target).getOsName().equalsIgnoreCase("Windows")) {
            this.log.warn((CharSequence)"NSIS installer can only be targeted for Windows platform!");
            this.log.warn((CharSequence)"The build will continue, but please check the the platform of this installer target.");
            return false;
        }
        if (!this.mojo.getMakensisUtility().exists()) {
            this.log.warn((CharSequence)("Cannot find NSIS compiler at this location: " + this.mojo.getMakensisUtility()));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your makensis executable.");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
        String finalName = ((NsisTarget)this.target).getFinalName();
        if (!finalName.endsWith(EXE_EXTENSION)) {
            finalName = finalName + EXE_EXTENSION;
        }
        this.filterProperties.put("finalName", ((NsisTarget)this.target).getFinalName());
        this.filterProperties.put(INSTALLATION_FILES, INSTALLATION_FILES);
        this.filterProperties.put(INSTANCES_FILES, INSTANCES_FILES);
        this.filterProperties.put("wrapper.java.command", "wrapper.java.command=@java.home@\\bin\\java.exe");
        this.filterProperties.put("double.quote", "\"");
    }

    @Override
    public File getInstallationDirectory() {
        return new File(this.getTargetDirectory(), INSTALLATION_FILES);
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getTargetDirectory(), "instancesFiles/default");
    }

    @Override
    public void copyWrapperFiles(GenerateMojo mojo) throws MojoFailureException {
        try {
            MojoHelperUtils.copyBinaryFile(mojo, WRAPPER_EXE_RESOURCE, this.getClass().getResourceAsStream(WRAPPER_EXE_RESOURCE), new File(this.getInstallationLayout().getBinDirectory(), WRAPPER_EXE_FILE));
            MojoHelperUtils.copyBinaryFile(mojo, WRAPPER_DLL_RESOURCE, this.getClass().getResourceAsStream(WRAPPER_DLL_RESOURCE), new File(this.getInstallationLayout().getLibDirectory(), WRAPPER_DLL_FILE));
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy Tanuki binary files to lib and bin directories");
        }
    }
}

