/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.installers.AbstractMojoCommand;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.Target;
import org.apache.maven.plugin.MojoFailureException;

public abstract class LinuxInstallerCommand<T extends Target>
extends AbstractMojoCommand<T> {
    protected static final String TAR = "tar";
    protected static final String ETC_INITD_SCRIPT = "etc-initd-script";
    protected static final String OPT_APACHEDS_DIR = "/opt/apacheds-";
    protected static final String VAR_LIB_APACHEDS_DIR = "/var/lib/apacheds-";
    protected static final String DEFAULT_INSTANCE_NAME_PROP = "default.instance.name";

    protected LinuxInstallerCommand(GenerateMojo mojo, T target) {
        super(mojo, target);
    }

    @Override
    public void copyWrapperFiles(GenerateMojo mojo) throws MojoFailureException {
        try {
            if (this.target.isOsArchI386() || this.target.isOsArchx86()) {
                mojo.getLog().info((CharSequence)("Copying wrapper files for " + this.target.getOsArch()));
                MojoHelperUtils.copyBinaryFile(mojo, "/org/apache/directory/server/installers/wrapper/bin/wrapper-linux-x86-32", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/bin/wrapper-linux-x86-32"), new File(this.getInstallationLayout().getBinDirectory(), "wrapper"));
                MojoHelperUtils.copyBinaryFile(mojo, "/org/apache/directory/server/installers/wrapper/lib/libwrapper-linux-x86-32.so", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/lib/libwrapper-linux-x86-32.so"), new File(this.getInstallationLayout().getLibDirectory(), "libwrapper.so"));
            } else if (this.target.isOsArchX86_64() || this.target.isOsArchAmd64()) {
                mojo.getLog().info((CharSequence)("Copying wrapper files for " + this.target.getOsArch()));
                MojoHelperUtils.copyBinaryFile(mojo, "/org/apache/directory/server/installers/wrapper/bin/wrapper-linux-x86-64", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/bin/wrapper-linux-x86-64"), new File(this.getInstallationLayout().getBinDirectory(), "wrapper"));
                MojoHelperUtils.copyBinaryFile(mojo, "/org/apache/directory/server/installers/wrapper/lib/libwrapper-linux-x86-64.so", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper/lib/libwrapper-linux-x86-64.so"), new File(this.getInstallationLayout().getLibDirectory(), "libwrapper.so"));
            } else {
                mojo.getLog().info((CharSequence)("No wrapper files to copy for " + this.target.getOsArch()));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy Tanuki binary files to lib and bin directories");
        }
    }
}

