/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.macosxpkg;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.installers.AbstractMojoCommand;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.macosxpkg.MacOsXPkgTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Execute;

public class MacOsXPkgInstallerCommand
extends AbstractMojoCommand<MacOsXPkgTarget> {
    private File hdiutilUtility = new File("/usr/bin/hdiutil");

    public MacOsXPkgInstallerCommand(GenerateMojo mojo, MacOsXPkgTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        this.log.info((CharSequence)"  Creating Mac OS X PKG installer...");
        File targetDirectory = this.getTargetDirectory();
        if (!targetDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{targetDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        this.log.info((CharSequence)"    Copying PKG installer files");
        File pkgRootDirectory = new File(targetDirectory, "root");
        if (!pkgRootDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        File pkgRootUsrBinDirectory = new File(pkgRootDirectory, "usr/bin");
        if (!pkgRootUsrBinDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootUsrBinDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        File pkgRootUsrLocalApachedsDirectory = new File(pkgRootDirectory, "usr/local/apacheds-" + this.mojo.getProject().getVersion());
        if (!pkgRootUsrLocalApachedsDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootUsrLocalApachedsDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        File pkgRootInstancesDirectory = new File(pkgRootUsrLocalApachedsDirectory, "instances");
        if (!pkgRootInstancesDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootInstancesDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        File pkgRootInstancesDefaultDirectory = new File(pkgRootInstancesDirectory, "default");
        if (!pkgRootInstancesDefaultDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootInstancesDefaultDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        File pkgRootInstancesDefaultConfDirectory = new File(pkgRootInstancesDefaultDirectory, "conf");
        if (!pkgRootInstancesDefaultConfDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootInstancesDefaultConfDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        File pkgRootInstancesDefaultDirectoryLog = new File(pkgRootInstancesDefaultDirectory, "log");
        if (!pkgRootInstancesDefaultDirectoryLog.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootInstancesDefaultDirectoryLog}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        File pkgRootInstancesDefaultDirectoryPartitions = new File(pkgRootInstancesDefaultDirectory, "partitions");
        if (!pkgRootInstancesDefaultDirectoryPartitions.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootInstancesDefaultDirectoryPartitions}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        File pkgRootInstancesDefaultDirectoryRun = new File(pkgRootInstancesDefaultDirectory, "run");
        if (!pkgRootInstancesDefaultDirectoryRun.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootInstancesDefaultDirectoryRun}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        File pkgRootLibraryLaunchDaemons = new File(pkgRootDirectory, "Library/LaunchDaemons");
        if (!pkgRootLibraryLaunchDaemons.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgRootLibraryLaunchDaemons}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        try {
            this.createLayouts();
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("apacheds-usr-bin.sh"), new File(pkgRootUsrBinDirectory, "apacheds"), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("org.apache.directory.server.plist"), new File(pkgRootLibraryLaunchDaemons, "org.apache.directory.server.plist"), true);
            File pkgResourcesEnglishDirectory = new File(targetDirectory, "Resources/en.lproj");
            if (!pkgResourcesEnglishDirectory.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgResourcesEnglishDirectory}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            File pkgScriptsDirectory = new File(targetDirectory, "scripts");
            if (!pkgScriptsDirectory.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{pkgScriptsDirectory}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("pkg-background.tiff"), new File(pkgResourcesEnglishDirectory, "background.tiff"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("License.rtf"), new File(pkgResourcesEnglishDirectory, "License.rtf"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("Info.plist"), new File(targetDirectory, "Info.plist"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("preflight"), new File(pkgScriptsDirectory, "preflight"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("postflight"), new File(pkgScriptsDirectory, "postflight"));
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy PKG resources files.");
        }
        this.log.info((CharSequence)"    Generating Mac OS X PKG Installer");
        Execute createPkgTask = new Execute();
        String[] cmd = new String[]{this.mojo.getPackageMakerUtility().getAbsolutePath(), "--root", "root/", "--resources", "Resources/", "--info", "Info.plist", "--title", "Apache Directory Server " + this.mojo.getProject().getVersion(), "--version", this.mojo.getProject().getVersion(), "--scripts", "scripts", "--out", "Apache Directory Server Installer.pkg"};
        createPkgTask.setCommandline(cmd);
        createPkgTask.setWorkingDirectory(targetDirectory);
        try {
            createPkgTask.execute();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed while trying to generate the PKG: " + e.getMessage());
        }
        this.log.info((CharSequence)"  Creating Mac OS X DMG...");
        File dmgDirectory = new File(this.mojo.getOutputDirectory(), ((MacOsXPkgTarget)this.target).getId() + "-dmg");
        if (!dmgDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{dmgDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        this.log.info((CharSequence)"    Copying DMG files");
        File dmgDmgBackgroundDirectory = new File(dmgDirectory, "dmg/.background");
        if (!dmgDmgBackgroundDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{dmgDmgBackgroundDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        try {
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("dmg-background.png"), new File(dmgDirectory, "dmg/.background/background.png"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("DS_Store"), new File(dmgDirectory, "dmg/.DS_Store"));
            MojoHelperUtils.copyFiles(new File(targetDirectory, "Apache Directory Server Installer.pkg"), new File(dmgDirectory, "dmg/Apache Directory Server Installer.pkg"));
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy DMG resources files.");
        }
        MojoHelperUtils.exec(new String[]{"chmod", "755", new File(dmgDirectory, "dmg/Apache Directory Server Installer.pkg/Contents/Resources/preflight").toString()}, dmgDirectory, false);
        MojoHelperUtils.exec(new String[]{"chmod", "755", new File(dmgDirectory, "dmg/Apache Directory Server Installer.pkg/Contents/Resources/postflight").toString()}, dmgDirectory, false);
        this.log.info((CharSequence)"    Generating Mac OS X DMG Installer");
        String finalName = ((MacOsXPkgTarget)this.target).getFinalName();
        if (!finalName.endsWith(".dmg")) {
            finalName = finalName + ".dmg";
        }
        try {
            Execute createDmgTask = new Execute();
            createDmgTask.setCommandline(new String[]{this.hdiutilUtility.getAbsolutePath(), "makehybrid", "-quiet", "-hfs", "-hfs-volume-name", "Apache Directory Server Installer", "-hfs-openfolder", "dmg/", "dmg/", "-o", "TMP.dmg"});
            createDmgTask.setWorkingDirectory(dmgDirectory);
            createDmgTask.execute();
            createDmgTask.setCommandline(new String[]{this.hdiutilUtility.getAbsolutePath(), "convert", "-quiet", "-format", "UDZO", "TMP.dmg", "-o", "../" + finalName});
            createDmgTask.execute();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed while trying to generate the DMG: " + e.getMessage());
        }
        this.log.info((CharSequence)("=> Mac OS X DMG generated at " + new File(this.mojo.getOutputDirectory(), finalName)));
    }

    private boolean verifyTarget() {
        if (!((MacOsXPkgTarget)this.target).getOsName().equalsIgnoreCase("Mac OS X")) {
            this.log.warn((CharSequence)"Mac OS X PKG installer can only be targeted for Mac OS X platform!");
            this.log.warn((CharSequence)"The build will continue, but please check the platform of this installer target.");
            return false;
        }
        if (!"Mac OS X".equalsIgnoreCase(System.getProperty("os.name"))) {
            this.log.warn((CharSequence)"Mac OS X PKG installer can only be built on a machine running Mac OS X!");
            this.log.warn((CharSequence)"The build will continue, generation of this target is skipped.");
            return false;
        }
        if (!this.mojo.getPackageMakerUtility().exists()) {
            this.log.warn((CharSequence)("Cannot find 'PackageMaker' utility at this location: " + this.mojo.getPackageMakerUtility()));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your 'Package Maker' utility.");
            return false;
        }
        if (!this.hdiutilUtility.exists()) {
            this.log.warn((CharSequence)("Cannot find 'hdiutil' utility at this location: " + this.hdiutilUtility));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your 'hdiutil' utility.");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
        this.filterProperties.put("installation.directory", "/usr/local/apacheds-" + this.mojo.getProject().getVersion());
        this.filterProperties.put("instances.directory", "/usr/local/apacheds-" + this.mojo.getProject().getVersion() + "/instances");
        this.filterProperties.put("user", "root");
        this.filterProperties.put("wrapper.java.command", "# wrapper.java.command=<path-to-java-executable>");
        this.filterProperties.put("double.quote", "");
    }

    @Override
    public File getInstallationDirectory() {
        return new File(this.getTargetDirectory(), "root/usr/local/apacheds-" + this.mojo.getProject().getVersion());
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getInstallationDirectory(), "instances/default");
    }
}

