/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.bin;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.installers.AbstractMojoCommand;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.bin.BinTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Execute;

public class BinInstallerCommand
extends AbstractMojoCommand<BinTarget> {
    private File shUtility = new File("/bin/sh");
    private String finalName;

    public BinInstallerCommand(GenerateMojo mojo, BinTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        this.log.info((CharSequence)"  Creating Bin installer...");
        if (!this.getTargetDirectory().mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{this.getTargetDirectory()}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        this.log.info((CharSequence)"    Copying Bin installer files");
        try {
            this.createInstallationLayout();
            File instanceDirectory = this.getInstanceDirectory();
            if (!instanceDirectory.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{instanceDirectory}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/log4j.properties"), new File(instanceDirectory, "log4j.properties"), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper-instance.conf"), new File(instanceDirectory, "wrapper.conf"), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/config.ldif"), new File(instanceDirectory, "config.ldif"), false);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/etc-initd-script"), new File(instanceDirectory, "etc-initd-script"), true);
            File binShDirectory = new File(this.getBinInstallerDirectory(), "sh");
            if (!binShDirectory.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{binShDirectory}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("bootstrap.sh"), new File(this.getBinInstallerDirectory(), "bootstrap.sh"), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("createInstaller.sh"), new File(this.getBinInstallerDirectory(), "createInstaller.sh"), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("functions.sh"), new File(binShDirectory, "functions.sh"), false);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("install.sh"), new File(binShDirectory, "install.sh"), false);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("variables.sh"), new File(binShDirectory, "variables.sh"), false);
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy bin installer files.");
        }
        this.log.info((CharSequence)"    Generating Bin installer");
        Execute createBinTask = new Execute();
        String[] cmd = new String[]{this.shUtility.getAbsolutePath(), "createInstaller.sh"};
        createBinTask.setCommandline(cmd);
        createBinTask.setWorkingDirectory(this.getBinInstallerDirectory());
        try {
            createBinTask.execute();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed while trying to generate the Bin: " + e.getMessage());
        }
        this.log.info((CharSequence)("Bin Installer generated at " + new File(this.getTargetDirectory(), this.finalName)));
    }

    private boolean verifyTarget() {
        if (!((BinTarget)this.target).isOsNameLinux()) {
            this.log.warn((CharSequence)"Bin installer can only be targeted for Linux platforms!");
            this.log.warn((CharSequence)"The build will continue, but please check the the platform of this installer target");
            return false;
        }
        if (!"Linux".equalsIgnoreCase(System.getProperty("os.name")) && !"Mac OS X".equalsIgnoreCase(System.getProperty("os.name"))) {
            this.log.warn((CharSequence)"Bin package installer can only be built on a machine running Linux or Mac OS X!");
            this.log.warn((CharSequence)"The build will continue, generation of this target is skipped.");
            return false;
        }
        if (!this.shUtility.exists()) {
            this.log.warn((CharSequence)("Cannot find sh utility at this location: " + this.shUtility));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your sh utility.");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
        this.filterProperties.put("tmpArchive", "__tmp.tar.gz");
        this.finalName = ((BinTarget)this.target).getFinalName();
        if (!this.finalName.endsWith(".bin")) {
            this.finalName = this.finalName + ".bin";
        }
        this.filterProperties.put("finalName", this.finalName);
        this.filterProperties.put("apacheds.version", this.mojo.getProject().getVersion());
        this.filterProperties.put("wrapper.java.command", "# wrapper.java.command=<path-to-java-executable>");
        this.filterProperties.put("double.quote", "");
    }

    private File getBinInstallerDirectory() {
        return new File(this.getTargetDirectory(), "bin");
    }

    @Override
    public File getInstallationDirectory() {
        return new File(this.getBinInstallerDirectory(), "server");
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getBinInstallerDirectory(), "instance");
    }
}

