/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.mavibot.btree.AbstractBTree;
import org.apache.directory.mavibot.btree.AbstractDeleteResult;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeHeader;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.ExistsResult;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.NotPresentResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PageIO;
import org.apache.directory.mavibot.btree.PersistedBTreeConfiguration;
import org.apache.directory.mavibot.btree.PersistedLeaf;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.SplitResult;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedBTree<K, V>
extends AbstractBTree<K, V>
implements Closeable {
    protected static final Logger LOG = LoggerFactory.getLogger(PersistedBTree.class);
    protected static final Logger LOG_PAGES = LoggerFactory.getLogger("org.apache.directory.mavibot.LOG_PAGES");
    protected LRUMap cache;
    public static final int DEFAULT_CACHE_SIZE = 1000;
    protected int cacheSize = 1000;
    private static final int DEFAULT_VALUE_THRESHOLD_UP = 8;
    private static final int DEFAULT_VALUE_THRESHOLD_LOW = 1;
    static int valueThresholdUp = 8;
    static int valueThresholdLow = 1;
    private long btreeInfoOffset;
    private RecordManager recordManager;

    PersistedBTree() {
        this.setType(BTreeTypeEnum.PERSISTED);
    }

    PersistedBTree(PersistedBTreeConfiguration<K, V> configuration) {
        String name = configuration.getName();
        if (name == null) {
            throw new IllegalArgumentException("BTree name cannot be null");
        }
        this.setName(name);
        this.setPageSize(configuration.getPageSize());
        this.setKeySerializer((ElementSerializer)configuration.getKeySerializer());
        this.setValueSerializer((ElementSerializer)configuration.getValueSerializer());
        this.setAllowDuplicates(configuration.isAllowDuplicates());
        this.setType(configuration.getBtreeType());
        this.readTimeOut = configuration.getReadTimeOut();
        this.writeBufferSize = configuration.getWriteBufferSize();
        this.cacheSize = configuration.getCacheSize();
        if (this.keySerializer.getComparator() == null) {
            throw new IllegalArgumentException("Comparator should not be null");
        }
        PersistedLeaf rootPage = new PersistedLeaf(this);
        BTreeHeader btreeHeader = new BTreeHeader();
        btreeHeader.setRootPage(rootPage);
        btreeHeader.setBtree(this);
        switch (this.btreeType) {
            case BTREE_OF_BTREES: 
            case COPIED_PAGES_BTREE: {
                this.init(null);
                this.currentBtreeHeader = btreeHeader;
                break;
            }
            case PERSISTED_SUB: {
                this.init((PersistedBTree)configuration.getParentBTree());
                this.btreeRevisions.put(0L, btreeHeader);
                this.currentBtreeHeader = btreeHeader;
                break;
            }
            default: {
                this.init(null);
                this.btreeRevisions.put(0L, btreeHeader);
                this.currentBtreeHeader = btreeHeader;
            }
        }
    }

    public void init(BTree<K, V> parentBTree) {
        if (parentBTree == null) {
            this.readTransactions = new ConcurrentLinkedQueue();
            if (this.cacheSize < 1) {
                this.cacheSize = 1;
            }
            this.cache = new LRUMap(this.cacheSize);
        } else {
            this.cache = ((PersistedBTree)parentBTree).getCache();
            this.readTransactions = ((PersistedBTree)parentBTree).getReadTransactions();
        }
    }

    LRUMap getCache() {
        return this.cache;
    }

    ConcurrentLinkedQueue<ReadTransaction<K, V>> getReadTransactions() {
        return this.readTransactions;
    }

    @Override
    public void close() throws IOException {
        this.cache.clear();
    }

    long getBtreeOffset() {
        return this.getBTreeHeader(this.getName()).getBTreeHeaderOffset();
    }

    void setBtreeHeaderOffset(long btreeHeaderOffset) {
        this.getBTreeHeader(this.getName()).setBTreeHeaderOffset(btreeHeaderOffset);
    }

    long getRootPageOffset() {
        return this.getBTreeHeader(this.getName()).getRootPageOffset();
    }

    RecordManager getRecordManager() {
        return this.recordManager;
    }

    void setRecordManager(RecordManager recordManager) {
        this.transactionManager = recordManager;
        this.recordManager = recordManager;
    }

    @Override
    Tuple<K, V> delete(K key, V value, long revision) throws IOException {
        if (revision == -1L) {
            revision = this.currentRevision.get() + 1L;
        }
        DeleteResult<K, V> result = this.processDelete(key, value, revision);
        if (result instanceof NotPresentResult) {
            return null;
        }
        AbstractDeleteResult deleteResult = (AbstractDeleteResult)result;
        Tuple tuple = deleteResult.getRemovedElement();
        return tuple;
    }

    private DeleteResult<K, V> processDelete(K key, V value, long revision) throws IOException {
        BTreeHeader<K, V> btreeHeader = this.getBTreeHeader(this.getName());
        DeleteResult<K, V> result = btreeHeader.getRootPage().delete(key, value, revision);
        if (result instanceof NotPresentResult) {
            return result;
        }
        BTreeHeader newBtreeHeader = btreeHeader.copy();
        if (this.btreeType == BTreeTypeEnum.BTREE_OF_BTREES || this.btreeType == BTreeTypeEnum.COPIED_PAGES_BTREE) {
            PageIO[] pageIos;
            for (PageIO pageIo : pageIos = this.recordManager.readPageIOs(btreeHeader.getBTreeHeaderOffset(), -1L)) {
                this.recordManager.freedPages.add(pageIo);
            }
        }
        AbstractDeleteResult removeResult = (AbstractDeleteResult)result;
        Page newRootPage = removeResult.getModifiedPage();
        PageHolder holder = this.writePage(newRootPage, revision);
        newBtreeHeader.decrementNbElems();
        newBtreeHeader.setRootPage(newRootPage);
        newBtreeHeader.setRevision(revision);
        long newBtreeHeaderOffset = this.recordManager.writeBtreeHeader(this, newBtreeHeader);
        switch (this.btreeType) {
            case PERSISTED: {
                this.recordManager.addInBtreeOfBtrees(this.getName(), revision, newBtreeHeaderOffset);
                this.recordManager.addInCopiedPagesBtree(this.getName(), revision, result.getCopiedPages());
                this.storeRevision(newBtreeHeader, this.recordManager.isKeepRevisions());
                break;
            }
            case PERSISTED_SUB: {
                this.recordManager.addInCopiedPagesBtree(this.getName(), revision, result.getCopiedPages());
                this.currentRevision.set(revision);
                break;
            }
            case BTREE_OF_BTREES: {
                this.recordManager.updateRecordManagerHeader(newBtreeHeaderOffset, -1L);
                this.recordManager.freePages(this, revision, result.getCopiedPages());
                this.storeRevision(newBtreeHeader, this.recordManager.isKeepRevisions());
                break;
            }
            case COPIED_PAGES_BTREE: {
                this.recordManager.updateRecordManagerHeader(-1L, newBtreeHeaderOffset);
                this.recordManager.freePages(this, revision, result.getCopiedPages());
                this.storeRevision(newBtreeHeader, this.recordManager.isKeepRevisions());
                break;
            }
        }
        return result;
    }

    @Override
    InsertResult<K, V> insert(K key, V value, long revision) throws IOException {
        if (revision == -1L) {
            revision = this.currentRevision.get() + 1L;
        }
        InsertResult<K, V> result = this.processInsert(key, value, revision);
        return result;
    }

    private BTreeHeader<K, V> getBTreeHeader(String name) {
        switch (this.btreeType) {
            case PERSISTED_SUB: {
                return this.getBtreeHeader();
            }
            case BTREE_OF_BTREES: {
                return this.recordManager.getNewBTreeHeader("_btree_of_btrees_");
            }
            case COPIED_PAGES_BTREE: {
                return this.recordManager.getNewBTreeHeader("_copiedPageBtree_");
            }
        }
        return this.recordManager.getBTreeHeader(this.getName());
    }

    private BTreeHeader<K, V> getNewBTreeHeader(String name) {
        if (this.btreeType == BTreeTypeEnum.PERSISTED_SUB) {
            return this.getBtreeHeader();
        }
        BTreeHeader btreeHeader = this.recordManager.getNewBTreeHeader(this.getName());
        return btreeHeader;
    }

    private InsertResult<K, V> processInsert(K key, V value, long revision) throws IOException {
        Page newRootPage;
        BTreeHeader<K, V> btreeHeader = this.getBTreeHeader(this.getName());
        InsertResult<K, V> result = btreeHeader.getRootPage().insert(key, value, revision);
        if (result instanceof ExistsResult) {
            return result;
        }
        BTreeHeader newBtreeHeader = btreeHeader.copy();
        if (this.btreeType == BTreeTypeEnum.BTREE_OF_BTREES || this.btreeType == BTreeTypeEnum.COPIED_PAGES_BTREE) {
            PageIO[] pageIos;
            for (PageIO pageIo : pageIos = this.recordManager.readPageIOs(btreeHeader.getBTreeHeaderOffset(), -1L)) {
                this.recordManager.freedPages.add(pageIo);
            }
        }
        if (result instanceof ModifyResult) {
            ModifyResult modifyResult = (ModifyResult)result;
            newRootPage = modifyResult.getModifiedPage();
            if (modifyResult.getModifiedValue() == null) {
                newBtreeHeader.incrementNbElems();
            }
        } else {
            SplitResult splitResult = (SplitResult)result;
            Object pivot = splitResult.getPivot();
            Page leftPage = splitResult.getLeftPage();
            Page rightPage = splitResult.getRightPage();
            PageHolder holderLeft = this.writePage(leftPage, revision);
            PageHolder holderRight = this.writePage(rightPage, revision);
            newRootPage = new PersistedNode(this, revision, pivot, holderLeft, holderRight);
            newBtreeHeader.incrementNbElems();
        }
        LOG_PAGES.debug("Writing the new rootPage revision {} for {}", (Object)revision, (Object)this.name);
        this.writePage(newRootPage, revision);
        newBtreeHeader.setRootPage(newRootPage);
        newBtreeHeader.setRevision(revision);
        long newBtreeHeaderOffset = this.recordManager.writeBtreeHeader(this, newBtreeHeader);
        switch (this.btreeType) {
            case PERSISTED: {
                this.recordManager.addInBtreeOfBtrees(this.getName(), revision, newBtreeHeaderOffset);
                this.recordManager.addInCopiedPagesBtree(this.getName(), revision, result.getCopiedPages());
                this.storeRevision(newBtreeHeader, this.recordManager.isKeepRevisions());
                break;
            }
            case PERSISTED_SUB: {
                this.recordManager.addInCopiedPagesBtree(this.getName(), revision, result.getCopiedPages());
                this.storeRevision(newBtreeHeader, this.recordManager.isKeepRevisions());
                this.currentRevision.set(revision);
                break;
            }
            case BTREE_OF_BTREES: {
                this.recordManager.updateRecordManagerHeader(newBtreeHeaderOffset, -1L);
                this.recordManager.freePages(this, revision, result.getCopiedPages());
                this.storeRevision(newBtreeHeader, this.recordManager.isKeepRevisions());
                break;
            }
            case COPIED_PAGES_BTREE: {
                this.recordManager.updateRecordManagerHeader(-1L, newBtreeHeaderOffset);
                this.recordManager.freePages(this, revision, result.getCopiedPages());
                this.storeRevision(newBtreeHeader, this.recordManager.isKeepRevisions());
                break;
            }
        }
        return result;
    }

    private void writeBuffer(FileChannel channel, ByteBuffer bb, byte[] buffer) throws IOException {
        int size = buffer.length;
        int pos = 0;
        do {
            if (bb.remaining() >= size) {
                bb.put(buffer, pos, size);
                size = 0;
                continue;
            }
            int len = bb.remaining();
            size -= len;
            bb.put(buffer, pos, len);
            pos += len;
            bb.flip();
            channel.write(bb);
            bb.clear();
        } while (size > 0);
    }

    private PageHolder<K, V> writePage(Page<K, V> modifiedPage, long revision) throws IOException {
        PageHolder<K, V> pageHolder = this.recordManager.writePage(this, modifiedPage, revision);
        return pageHolder;
    }

    @Override
    public Page<K, V> getRootPage(long revision) throws IOException, KeyNotFoundException {
        return this.recordManager.getRootPage(this, revision);
    }

    @Override
    public Page<K, V> getRootPage() {
        return this.getBTreeHeader(this.getName()).getRootPage();
    }

    @Override
    void setRootPage(Page<K, V> root) {
        this.getBTreeHeader(this.getName()).setRootPage(root);
    }

    public long getBtreeInfoOffset() {
        return this.btreeInfoOffset;
    }

    public void setBtreeInfoOffset(long btreeInfoOffset) {
        this.btreeInfoOffset = btreeInfoOffset;
    }

    @Override
    protected ReadTransaction<K, V> beginReadTransaction() {
        BTreeHeader<K, V> btreeHeader = this.getBTreeHeader(this.getName());
        ReadTransaction<K, V> readTransaction = new ReadTransaction<K, V>(this.recordManager, btreeHeader, this.readTransactions);
        this.readTransactions.add(readTransaction);
        return readTransaction;
    }

    @Override
    protected ReadTransaction<K, V> beginReadTransaction(long revision) {
        BTreeHeader btreeHeader = this.getBtreeHeader(revision);
        if (btreeHeader != null) {
            ReadTransaction readTransaction = new ReadTransaction(this.recordManager, btreeHeader, this.readTransactions);
            this.readTransactions.add(readTransaction);
            return readTransaction;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Managed BTree");
        sb.append("[").append(this.getName()).append("]");
        sb.append("( pageSize:").append(this.getPageSize());
        if (this.getBTreeHeader(this.getName()).getRootPage() != null) {
            sb.append(", nbEntries:").append(this.getBTreeHeader(this.getName()).getNbElems());
        } else {
            sb.append(", nbEntries:").append(0);
        }
        sb.append(", comparator:");
        if (this.keySerializer.getComparator() == null) {
            sb.append("null");
        } else {
            sb.append(this.keySerializer.getComparator().getClass().getSimpleName());
        }
        sb.append(", DuplicatesAllowed: ").append(this.isAllowDuplicates());
        sb.append(") : \n");
        sb.append(this.getBTreeHeader(this.getName()).getRootPage().dumpPage(""));
        return sb.toString();
    }
}

