/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.UUID;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.comparators.DnComparator;
import org.apache.directory.server.core.api.partition.Partition;

public class DnTuple
implements Comparable<DnTuple> {
    private Dn dn;
    private int len;
    private long offset;
    private String id;
    private DnTuple parent;
    private int nbChildren = 0;
    private int nbDecendents = 0;
    private static final DnComparator COMPARATOR = new DnComparator(null);

    public DnTuple(Dn dn, long offset, int len) {
        this.dn = dn;
        this.offset = offset;
        this.len = len;
        this.id = UUID.randomUUID().toString();
    }

    public Dn getDn() {
        return this.dn;
    }

    public int getLen() {
        return this.len;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getParentId() {
        if (this.parent == null) {
            return Partition.ROOT_ID;
        }
        return this.parent.getId();
    }

    public DnTuple getParent() {
        return this.parent;
    }

    public void setParent(DnTuple parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(DnTuple otherTuple) {
        return COMPARATOR.compare(otherTuple.dn, this.dn);
    }

    public int hashCode() {
        return this.dn.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        DnTuple other = (DnTuple)obj;
        return !(this.dn == null ? other.dn != null : !this.dn.equals(other.dn));
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getNbChildren() {
        return this.nbChildren;
    }

    public int getNbDecendents() {
        return this.nbDecendents;
    }

    public void addChild() {
        ++this.nbChildren;
    }

    public void addDecendent() {
        ++this.nbDecendents;
        if (this.parent != null) {
            this.parent.addDecendent();
        }
    }

    public String toString() {
        return "DnTuple [dn=" + this.dn + ", len=" + this.len + ", offset=" + this.offset + ", id=" + this.id + ", parentId=" + this.getParentId() + ", nbChildren=" + this.nbChildren + ", nbDecendents=" + this.nbDecendents + "]";
    }
}

