/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.template;

import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyErrorEnum;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyResponse;
import org.apache.directory.ldap.client.template.PasswordWarning;

class PasswordWarningImpl
implements PasswordWarning {
    private static final long serialVersionUID = -8952246313604352357L;
    private int timeBeforeExpiration = -1;
    private int graceAuthNsRemaining = -1;
    private boolean changeAfterReset = false;

    private PasswordWarningImpl() {
    }

    public static PasswordWarning newWarning(PasswordPolicy policy) {
        PasswordPolicyResponse response = policy.getResponse();
        if (response != null) {
            PasswordWarningImpl policyWarning = new PasswordWarningImpl();
            policyWarning.timeBeforeExpiration = response.getTimeBeforeExpiration();
            policyWarning.graceAuthNsRemaining = response.getGraceAuthNRemaining();
            boolean bl = policyWarning.changeAfterReset = response.getPasswordPolicyError() == PasswordPolicyErrorEnum.CHANGE_AFTER_RESET;
            if (policyWarning.timeBeforeExpiration >= 0 || policyWarning.graceAuthNsRemaining >= 0 || policyWarning.changeAfterReset) {
                return policyWarning;
            }
        }
        return null;
    }

    @Override
    public int getTimeBeforeExpiration() {
        return this.timeBeforeExpiration;
    }

    @Override
    public int getGraceAuthNsRemaining() {
        return this.graceAuthNsRemaining;
    }

    @Override
    public boolean isChangeAfterReset() {
        return this.changeAfterReset;
    }
}

