/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap.partition;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.directory.server.schema.bootstrap.partition.DbFileListing;

public class SchemaPartitionExtractor {
    private DbFileListing listing;
    private File outputDirectory;

    public SchemaPartitionExtractor(File outputDirectory) throws IOException {
        this.outputDirectory = outputDirectory;
        this.listing = new DbFileListing();
    }

    public void extract() throws IOException {
        File schemaDirectory;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (!(schemaDirectory = new File(this.outputDirectory, "schema")).exists()) {
            schemaDirectory.mkdirs();
        }
        Iterator<String> ii = this.listing.iterator();
        while (ii.hasNext()) {
            this.extract(ii.next());
        }
    }

    public DbFileListing getDbFileListing() {
        return this.listing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(String resource) throws IOException {
        byte[] buf = new byte[512];
        InputStream in = DbFileListing.getUniqueResourceAsStream(resource);
        try {
            FileOutputStream out = new FileOutputStream(new File(this.outputDirectory, resource));
            try {
                while (in.available() > 0) {
                    int readCount = in.read(buf);
                    out.write(buf, 0, readCount);
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }
}

