/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.avl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.partition.avl.AvlIndex;
import org.apache.directory.server.core.partition.avl.AvlStore;
import org.apache.directory.server.xdbm.AbstractXdbmPartition;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ServerEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlPartition
extends AbstractXdbmPartition<Long> {
    private Set<AvlIndex<?, ServerEntry>> indexedAttributes = new HashSet();

    public AvlPartition() {
        super(new AvlStore());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doInit() throws Exception {
        this.setSchemaManager(this.schemaManager);
        EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this.store, this.schemaManager);
        CursorBuilder cursorBuilder = new CursorBuilder(this.store, evaluatorBuilder);
        this.optimizer = !this.optimizerEnabled ? new NoOpOptimizer() : new DefaultOptimizer(this.store);
        this.searchEngine = new DefaultSearchEngine(this.store, cursorBuilder, evaluatorBuilder, this.optimizer);
        if (this.store.isInitialized()) {
            return;
        }
        this.store.setName(this.getId());
        this.suffix.normalize(this.schemaManager.getNormalizerMapping());
        this.store.setSuffixDn(this.suffix.getName());
        HashSet<AvlIndex<Object, Object>> userIndices = new HashSet<AvlIndex<Object, Object>>();
        for (AvlIndex<?, ServerEntry> obj : this.indexedAttributes) {
            AvlIndex<Object, Object> index;
            if (obj instanceof AvlIndex) {
                index = obj;
            } else {
                index = new AvlIndex();
                index.setAttributeId(obj.getAttributeId());
            }
            String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(index.getAttributeId());
            if (SYS_INDEX_OIDS.contains(this.schemaManager.getAttributeTypeRegistry().getOidByName(index.getAttributeId()))) {
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                    this.store.setAliasIndex(index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                    this.store.setPresenceIndex(index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                    this.store.setOneLevelIndex(index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                    this.store.setNdnIndex(index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                    this.store.setOneAliasIndex(index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                    this.store.setSubAliasIndex(index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                    this.store.setUpdnIndex(index);
                } else {
                    if (!oid.equals("2.5.4.0")) throw new IllegalStateException("Unrecognized system index " + oid);
                    this.store.addIndex(index);
                }
            } else {
                userIndices.add(index);
            }
            this.store.setUserIndices(userIndices);
        }
        this.store.init(this.schemaManager);
    }

    public final void modify(long entryId, List<Modification> modifications) throws Exception {
        ((AvlStore)this.store).modify(entryId, modifications);
    }

    public AvlStore<ServerEntry> getStore() {
        return (AvlStore)this.store;
    }
}

