/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.changelog.Tag;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDSTestExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOG = LoggerFactory.getLogger(CreateDSTestExtension.class);
    private static final String CLASS_DS = "classDirectoryService";
    private static final String METHOD_DS = "methodDirectoryService";

    private void setDirectoryService(ExtensionContext context, String fieldName, DirectoryService directoryService) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> testClass = context.getTestClass().get();
        Field field = testClass.getField(fieldName);
        field.set(null, directoryService);
    }

    private DirectoryService getDirectoryService(ExtensionContext context, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> testClass = context.getTestClass().get();
        Field directoryServiceField = testClass.getField(fieldName);
        if (directoryServiceField != null) {
            return (DirectoryService)directoryServiceField.get(testClass);
        }
        return null;
    }

    @Override
    public void beforeAll(ExtensionContext context) throws Exception {
        DirectoryService directoryService;
        if (context.getTestClass().get().getAnnotation(Disabled.class) != null) {
            return;
        }
        AnnotatedElement classAnnotation = context.getTestClass().get();
        CreateDS createDs = classAnnotation.getAnnotation(CreateDS.class);
        if (createDs == null) {
            DirectoryServiceFactory dsf = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
            directoryService = dsf.getDirectoryService();
            directoryService.getChangeLog().setEnabled(true);
            dsf.init("default" + UUID.randomUUID().toString());
            if (directoryService != null) {
                Tag tag = directoryService.getChangeLog().tag();
                DSAnnotationProcessor.applyLdifs(classAnnotation, classAnnotation.getClass().getName(), directoryService);
                LOG.debug("Tagged change log: {}", (Object)tag);
            } else {
                LOG.trace("no @CreateDS and no outer @CreateDS on: {}", (Object)classAnnotation.getClass().getName());
            }
        } else {
            LOG.trace("Creating directory service");
            directoryService = DSAnnotationProcessor.getDirectoryService(createDs);
            DSAnnotationProcessor.applyLdifs(classAnnotation, classAnnotation.getClass().getName(), directoryService);
        }
        CreateLdapServer createLapServer = classAnnotation.getAnnotation(CreateLdapServer.class);
        if (createLapServer == null) {
            System.out.println("");
        } else {
            LdapServer ldapServer = ServerAnnotationProcessor.createLdapServer(createLapServer, directoryService);
        }
        this.setDirectoryService(context, CLASS_DS, directoryService);
    }

    @Override
    public void afterAll(ExtensionContext context) throws Exception {
        LOG.trace("Shutting down global directory service");
        Class<?> testClass = context.getTestClass().get();
        Field directoryServiceField = testClass.getField(CLASS_DS);
        DirectoryService directoryService = (DirectoryService)directoryServiceField.get(testClass);
        Method shutdownMethod = directoryService.getClass().getDeclaredMethod("shutdown", new Class[0]);
        shutdownMethod.invoke((Object)directoryService, new Object[0]);
        FileUtils.deleteDirectory(directoryService.getInstanceLayout().getInstanceDirectory());
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        if (context.getTestMethod().get().getAnnotation(Disabled.class) != null) {
            return;
        }
        AnnotatedElement methodAnnotation = context.getTestMethod().get();
        AnnotatedElement classAnnotation = context.getTestClass().get();
        CreateDS createDs = methodAnnotation.getAnnotation(CreateDS.class);
        if (createDs != null) {
            LOG.trace("Creating directory service");
            DirectoryService directoryService = DSAnnotationProcessor.getDirectoryService(createDs);
            DSAnnotationProcessor.applyLdifs(classAnnotation, classAnnotation.getClass().getName(), directoryService);
            DSAnnotationProcessor.applyLdifs(methodAnnotation, methodAnnotation.getClass().getName(), directoryService);
            this.setDirectoryService(context, METHOD_DS, directoryService);
        } else {
            DirectoryService directoryService = this.getDirectoryService(context, CLASS_DS);
            DSAnnotationProcessor.applyLdifs(methodAnnotation, methodAnnotation.getClass().getName(), directoryService);
        }
    }

    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        LOG.trace("Shutting down directory service");
        Class<?> testClass = context.getTestClass().get();
        Field directoryServiceField = testClass.getField(METHOD_DS);
        DirectoryService directoryService = (DirectoryService)directoryServiceField.get(testClass);
        if (directoryService != null) {
            Method shutdownMethod = directoryService.getClass().getDeclaredMethod("shutdown", new Class[0]);
            shutdownMethod.invoke((Object)directoryService, new Object[0]);
            FileUtils.deleteDirectory(directoryService.getInstanceLayout().getInstanceDirectory());
            this.setDirectoryService(context, METHOD_DS, null);
        }
    }
}

