/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.BorrowedFromLeftResult;
import org.apache.directory.mavibot.btree.BorrowedFromRightResult;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.EmptyTupleCursor;
import org.apache.directory.mavibot.btree.ExistsResult;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.KeyCursor;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.MergedWithSiblingResult;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.NotPresentResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.PersistedKeyHolder;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedValueHolder;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.RemoveResult;
import org.apache.directory.mavibot.btree.SplitResult;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;

class PersistedLeaf<K, V>
extends AbstractPage<K, V> {
    protected ValueHolder<V>[] values;

    PersistedLeaf(BTree<K, V> btree) {
        super(btree);
    }

    PersistedLeaf(BTree<K, V> btree, long revision, int nbElems) {
        super(btree, revision, nbElems);
        if (btree.getType() != BTreeTypeEnum.PERSISTED_SUB) {
            this.values = (ValueHolder[])Array.newInstance(PersistedValueHolder.class, nbElems);
        }
    }

    @Override
    public InsertResult<K, V> insert(K key, V value, long revision) throws IOException {
        boolean isSubTree;
        int pos = this.findPos(key);
        boolean bl = isSubTree = this.btree.getType() == BTreeTypeEnum.PERSISTED_SUB;
        if (pos < 0) {
            int index = -(pos + 1);
            if (isSubTree) {
                return ExistsResult.EXISTS;
            }
            InsertResult<K, V> result = this.replaceElement(revision, key, value, index);
            return result;
        }
        if (this.nbElems < this.btree.getPageSize()) {
            Page<K, V> modifiedPage = null;
            modifiedPage = isSubTree ? this.addSubTreeElement(revision, key, pos) : this.addElement(revision, key, value, pos);
            ModifyResult<K, Object> result = new ModifyResult<K, Object>(modifiedPage, null);
            result.addCopiedPage(this);
            return result;
        }
        InsertResult<K, V> result = null;
        result = isSubTree ? this.addAndSplitSubTree(revision, key, pos) : this.addAndSplit(revision, key, value, pos);
        result.addCopiedPage(this);
        return result;
    }

    @Override
    DeleteResult<K, V> delete(K key, V value, long revision, Page<K, V> parent, int parentPos) throws IOException {
        if (this.nbElems == 0) {
            return NotPresentResult.NOT_PRESENT;
        }
        int pos = this.findPos(key);
        if (pos >= 0) {
            return NotPresentResult.NOT_PRESENT;
        }
        Tuple removedElement = null;
        boolean keyRemoved = false;
        int index = -(pos + 1);
        boolean isNotSubTree = this.btree.getType() != BTreeTypeEnum.PERSISTED_SUB;
        ValueHolder<V> valueHolder = null;
        if (isNotSubTree) {
            valueHolder = this.values[index];
        } else {
            value = null;
        }
        if (value == null) {
            removedElement = new Tuple(this.keys[index].getKey(), value);
            keyRemoved = true;
        } else if (valueHolder.contains(value)) {
            keyRemoved = valueHolder.size() == 1;
            removedElement = new Tuple(this.keys[index].getKey(), value);
        } else {
            return NotPresentResult.NOT_PRESENT;
        }
        PersistedLeaf<K, V> newLeaf = null;
        newLeaf = keyRemoved ? new PersistedLeaf<K, V>(this.btree, revision, this.nbElems - 1) : new PersistedLeaf<K, V>(this.btree, revision, this.nbElems);
        RemoveResult<K, V> defaultResult = new RemoveResult<K, V>(newLeaf, removedElement);
        if (parent == null) {
            this.copyAfterRemovingElement(keyRemoved, value, newLeaf, index);
            defaultResult.addCopiedPage(this);
            return defaultResult;
        }
        if (keyRemoved) {
            int halfSize = this.btree.getPageSize() / 2;
            if (this.nbElems == halfSize) {
                int siblingPos = this.selectSibling(parent, parentPos);
                PersistedLeaf sibling = (PersistedLeaf)((PersistedNode)parent).getPage(siblingPos);
                if (sibling.getNbElems() == halfSize) {
                    DeleteResult result = this.mergeWithSibling(removedElement, revision, sibling, siblingPos < parentPos, index);
                    return result;
                }
                if (siblingPos < parentPos) {
                    DeleteResult result = this.borrowFromLeft(removedElement, revision, sibling, index);
                    return result;
                }
                DeleteResult result = this.borrowFromRight(removedElement, revision, sibling, index);
                return result;
            }
            this.copyAfterRemovingElement(true, value, newLeaf, index);
            defaultResult.addCopiedPage(this);
            return defaultResult;
        }
        System.arraycopy(this.keys, 0, newLeaf.keys, 0, this.nbElems);
        System.arraycopy(this.values, 0, newLeaf.values, 0, this.nbElems);
        try {
            ValueHolder<V> newValueHolder = valueHolder.clone();
            newValueHolder.remove(value);
            newLeaf.values[pos] = newValueHolder;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        defaultResult.addCopiedPage(this);
        return defaultResult;
    }

    private DeleteResult<K, V> mergeWithSibling(Tuple<K, V> removedElement, long revision, PersistedLeaf<K, V> sibling, boolean isLeft, int pos) throws EndOfFileExceededException, IOException {
        boolean isNotSubTree = this.btree.getType() != BTreeTypeEnum.PERSISTED_SUB;
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, this.btree.getPageSize() - 1);
        if (isLeft) {
            System.arraycopy(sibling.keys, 0, newLeaf.keys, 0, sibling.nbElems);
            if (isNotSubTree) {
                System.arraycopy(sibling.values, 0, newLeaf.values, 0, sibling.nbElems);
            }
            System.arraycopy(this.keys, 0, newLeaf.keys, sibling.nbElems, pos);
            if (isNotSubTree) {
                System.arraycopy(this.values, 0, newLeaf.values, sibling.nbElems, pos);
            }
            System.arraycopy(this.keys, pos + 1, newLeaf.keys, sibling.nbElems + pos, this.nbElems - pos - 1);
            if (isNotSubTree) {
                System.arraycopy(this.values, pos + 1, newLeaf.values, sibling.nbElems + pos, this.nbElems - pos - 1);
            }
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            if (isNotSubTree) {
                System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            }
            System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos, this.nbElems - pos - 1);
            if (isNotSubTree) {
                System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.nbElems - pos - 1);
            }
            System.arraycopy(sibling.keys, 0, newLeaf.keys, this.nbElems - 1, sibling.nbElems);
            if (isNotSubTree) {
                System.arraycopy(sibling.values, 0, newLeaf.values, this.nbElems - 1, sibling.nbElems);
            }
        }
        MergedWithSiblingResult<K, V> result = new MergedWithSiblingResult<K, V>(newLeaf, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromLeft(Tuple<K, V> removedElement, long revision, PersistedLeaf<K, V> sibling, int pos) throws IOException {
        boolean isNotSubTree = this.btree.getType() != BTreeTypeEnum.PERSISTED_SUB;
        Object siblingKey = sibling.keys[sibling.getNbElems() - 1].getKey();
        ValueHolder<V> siblingValue = null;
        if (isNotSubTree) {
            siblingValue = sibling.values[sibling.getNbElems() - 1];
        }
        PersistedLeaf newSibling = (PersistedLeaf)super.copy(revision, sibling.getNbElems() - 1);
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, this.nbElems);
        newLeaf.keys[0] = new PersistedKeyHolder(this.btree.getKeySerializer(), siblingKey);
        if (isNotSubTree) {
            newLeaf.values[0] = siblingValue;
        }
        System.arraycopy(this.keys, 0, newLeaf.keys, 1, pos);
        if (isNotSubTree) {
            System.arraycopy(this.values, 0, newLeaf.values, 1, pos);
        }
        System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos + 1, this.keys.length - pos - 1);
        if (isNotSubTree) {
            System.arraycopy(this.values, pos + 1, newLeaf.values, pos + 1, this.values.length - pos - 1);
        }
        BorrowedFromLeftResult<K, V> result = new BorrowedFromLeftResult<K, V>(newLeaf, newSibling, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromRight(Tuple<K, V> removedElement, long revision, PersistedLeaf<K, V> sibling, int pos) throws IOException {
        boolean isNotSubTree = this.btree.getType() != BTreeTypeEnum.PERSISTED_SUB;
        Object siblingKey = sibling.keys[0].getKey();
        ValueHolder<V> siblingHolder = null;
        if (isNotSubTree) {
            siblingHolder = sibling.values[0];
        }
        PersistedLeaf<K, V> newSibling = new PersistedLeaf<K, V>(this.btree, revision, sibling.getNbElems() - 1);
        System.arraycopy(sibling.keys, 1, newSibling.keys, 0, sibling.nbElems - 1);
        if (isNotSubTree) {
            System.arraycopy(sibling.values, 1, newSibling.values, 0, sibling.nbElems - 1);
        }
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, this.nbElems);
        newLeaf.keys[this.nbElems - 1] = new PersistedKeyHolder(this.btree.getKeySerializer(), siblingKey);
        if (isNotSubTree) {
            newLeaf.values[this.nbElems - 1] = siblingHolder;
        }
        System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
        if (isNotSubTree) {
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
        }
        System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos, this.keys.length - pos - 1);
        if (isNotSubTree) {
            System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.values.length - pos - 1);
        }
        BorrowedFromRightResult<K, V> result = new BorrowedFromRightResult<K, V>(newLeaf, newSibling, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private void copyAfterRemovingElement(boolean keyRemoved, V removedValue, PersistedLeaf<K, V> newLeaf, int pos) throws IOException {
        boolean isNotSubTree;
        boolean bl = isNotSubTree = this.btree.getType() != BTreeTypeEnum.PERSISTED_SUB;
        if (keyRemoved) {
            if (this.nbElems == 1) {
                return;
            }
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            if (isNotSubTree) {
                System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            }
            System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos, this.keys.length - pos - 1);
            if (isNotSubTree) {
                System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.values.length - pos - 1);
            }
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, this.nbElems);
            System.arraycopy(this.values, 0, newLeaf.values, 0, this.nbElems);
            ValueHolder<V> valueHolder = newLeaf.values[pos];
            try {
                ValueHolder<V> newValueHolder = valueHolder.clone();
                newValueHolder.remove(removedValue);
                newLeaf.values[pos] = newValueHolder;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public V get(K key) throws KeyNotFoundException, IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            ValueHolder<V> valueHolder = this.values[-(pos + 1)];
            ValueCursor<V> cursor = valueHolder.getCursor();
            cursor.beforeFirst();
            if (cursor.hasNext()) {
                V value = cursor.next();
                return value;
            }
            return null;
        }
        throw KeyNotFoundException.INSTANCE;
    }

    KeyHolder<K> getKeyHolder(int pos) {
        if (pos < this.nbElems) {
            return this.keys[pos];
        }
        return null;
    }

    @Override
    public ValueCursor<V> getValues(K key) throws KeyNotFoundException, IOException, IllegalArgumentException {
        if (!this.btree.isAllowDuplicates()) {
            throw new IllegalArgumentException("Duplicates are not allowed in this tree");
        }
        int pos = this.findPos(key);
        if (pos < 0) {
            ValueHolder<V> valueHolder = this.values[-(pos + 1)];
            return valueHolder.getCursor();
        }
        throw KeyNotFoundException.INSTANCE;
    }

    @Override
    public boolean hasKey(K key) {
        int pos = this.findPos(key);
        return pos < 0;
    }

    @Override
    public boolean contains(K key, V value) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            ValueHolder<V> valueHolder = this.values[-(pos + 1)];
            return valueHolder.contains(value);
        }
        return false;
    }

    @Override
    ValueHolder<V> getValue(int pos) {
        if (pos < this.nbElems) {
            return this.values[pos];
        }
        return null;
    }

    @Override
    void setValue(int pos, ValueHolder<V> value) {
        this.values[pos] = value;
    }

    @Override
    public TupleCursor<K, V> browse(K key, ReadTransaction<K, V> transaction, ParentPos<K, V>[] stack, int depth) {
        int stackIndex;
        int pos = this.findPos(key);
        if (this.nbElems == 0) {
            return new EmptyTupleCursor();
        }
        TupleCursor<K, V> cursor = new TupleCursor<K, V>(transaction, stack, depth);
        if (pos < 0) {
            pos = -(pos + 1);
            ParentPos parentPos = new ParentPos(this, pos);
            parentPos.valueCursor = this.values[pos].getCursor();
            stack[depth] = parentPos;
            return cursor;
        }
        if (pos < this.nbElems) {
            ParentPos parentPos = new ParentPos(this, pos);
            parentPos.valueCursor = this.values[pos].getCursor();
            stack[depth] = parentPos;
            return cursor;
        }
        if (depth == 0) {
            stack[depth] = new ParentPos(this, pos);
            try {
                cursor.afterLast();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return cursor;
        }
        boolean isLast = true;
        stack[depth] = new ParentPos(this, pos);
        for (int i2 = stackIndex = depth - 1; i2 >= 0; --i2) {
            if (stack[i2].pos < stack[i2].page.getNbElems()) {
                isLast = false;
                break;
            }
            --stackIndex;
        }
        if (isLast) {
            try {
                cursor.afterLast();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return cursor;
        }
        return cursor;
    }

    @Override
    public TupleCursor<K, V> browse(ReadTransaction<K, V> transaction, ParentPos<K, V>[] stack, int depth) {
        int pos = 0;
        TupleCursor<K, V> cursor = null;
        if (this.nbElems == 0) {
            stack[depth] = new ParentPos(null, -1);
            return new TupleCursor<K, V>(transaction, stack, depth);
        }
        ParentPos parentPos = new ParentPos(this, pos);
        parentPos.valueCursor = this.values[0].getCursor();
        stack[depth] = parentPos;
        cursor = new TupleCursor<K, V>(transaction, stack, depth);
        return cursor;
    }

    private Page<K, V> copy(long revision, int nbElems) {
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, nbElems);
        System.arraycopy(this.keys, 0, newLeaf.keys, 0, nbElems);
        if (this.values != null) {
            int pos = 0;
            for (ValueHolder<V> valueHolder : this.values) {
                try {
                    newLeaf.values[pos++] = valueHolder.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                if (pos == nbElems) break;
            }
        }
        return newLeaf;
    }

    private InsertResult<K, V> replaceElement(long revision, K key, V value, int pos) throws IOException {
        PersistedLeaf newLeaf = this;
        ValueHolder<V> valueHolder = this.values[pos];
        boolean valueExists = valueHolder.contains(value);
        if (this.revision != revision) {
            newLeaf = (PersistedLeaf)this.copy(revision, this.nbElems);
        }
        valueHolder = newLeaf.values[pos];
        Object replacedValue = null;
        if (!valueExists && this.btree.isAllowDuplicates()) {
            valueHolder.add(value);
            newLeaf.values[pos] = valueHolder;
        } else if (valueExists && this.btree.isAllowDuplicates()) {
            replacedValue = valueHolder.remove(value);
            valueHolder.add(value);
        } else if (!this.btree.isAllowDuplicates()) {
            replacedValue = valueHolder.replaceValueArray(value);
        }
        ModifyResult result = new ModifyResult(newLeaf, replacedValue);
        result.addCopiedPage(this);
        return result;
    }

    private Page<K, V> addElement(long revision, K key, V value, int pos) {
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, this.nbElems + 1);
        PersistedValueHolder<Object> valueHolder = new PersistedValueHolder<Object>(this.btree, value);
        if (this.nbElems == 0) {
            newLeaf.keys[0] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            newLeaf.values[0] = valueHolder;
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            newLeaf.keys[pos] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            newLeaf.values[pos] = valueHolder;
            System.arraycopy(this.keys, pos, newLeaf.keys, pos + 1, this.keys.length - pos);
            System.arraycopy(this.values, pos, newLeaf.values, pos + 1, this.values.length - pos);
        }
        return newLeaf;
    }

    private InsertResult<K, V> addAndSplit(long revision, K key, V value, int pos) {
        int middle = this.btree.getPageSize() >> 1;
        PersistedLeaf<K, V> leftLeaf = null;
        PersistedLeaf<K, V> rightLeaf = null;
        PersistedValueHolder<Object> valueHolder = new PersistedValueHolder<Object>(this.btree, value);
        if (pos <= middle) {
            leftLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle + 1);
            System.arraycopy(this.keys, 0, leftLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, leftLeaf.values, 0, pos);
            leftLeaf.keys[pos] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            leftLeaf.values[pos] = valueHolder;
            System.arraycopy(this.keys, pos, leftLeaf.keys, pos + 1, middle - pos);
            System.arraycopy(this.values, pos, leftLeaf.values, pos + 1, middle - pos);
            rightLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.keys, middle, rightLeaf.keys, 0, middle);
            System.arraycopy(this.values, middle, rightLeaf.values, 0, middle);
        } else {
            leftLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.keys, 0, leftLeaf.keys, 0, middle);
            System.arraycopy(this.values, 0, leftLeaf.values, 0, middle);
            rightLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle + 1);
            int rightPos = pos - middle;
            System.arraycopy(this.keys, middle, rightLeaf.keys, 0, rightPos);
            System.arraycopy(this.values, middle, rightLeaf.values, 0, rightPos);
            rightLeaf.keys[rightPos] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            rightLeaf.values[rightPos] = valueHolder;
            System.arraycopy(this.keys, pos, rightLeaf.keys, rightPos + 1, this.nbElems - pos);
            System.arraycopy(this.values, pos, rightLeaf.values, rightPos + 1, this.nbElems - pos);
        }
        Object pivot = rightLeaf.keys[0].getKey();
        SplitResult result = new SplitResult(pivot, leftLeaf, rightLeaf);
        return result;
    }

    @Override
    public K getLeftMostKey() {
        return this.keys[0].getKey();
    }

    @Override
    public K getRightMostKey() {
        return this.keys[this.nbElems - 1].getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tuple<K, V> findLeftMost() throws IOException {
        boolean isSubTree;
        Object key = this.keys[0].getKey();
        boolean bl = isSubTree = this.btree.getType() == BTreeTypeEnum.PERSISTED_SUB;
        if (isSubTree) {
            return new Tuple(key, null);
        }
        ValueCursor<V> cursor = this.values[0].getCursor();
        try {
            cursor.beforeFirst();
            if (cursor.hasNext()) {
                Tuple tuple = new Tuple(key, cursor.next());
                return tuple;
            }
            Tuple tuple = new Tuple(key, null);
            return tuple;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tuple<K, V> findRightMost() throws EndOfFileExceededException, IOException {
        boolean isSubTree;
        Object key = this.keys[this.nbElems - 1].getKey();
        boolean bl = isSubTree = this.btree.getType() == BTreeTypeEnum.PERSISTED_SUB;
        if (isSubTree) {
            return new Tuple(key, null);
        }
        ValueCursor<V> cursor = this.values[this.nbElems - 1].getCursor();
        try {
            cursor.afterLast();
            if (cursor.hasPrev()) {
                Tuple tuple = new Tuple(key, cursor.prev());
                return tuple;
            }
            Tuple tuple = new Tuple(key, null);
            return tuple;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Leaf[");
        sb.append(super.toString());
        sb.append("] -> {");
        if (this.nbElems > 0) {
            boolean isFirst = true;
            for (int i2 = 0; i2 < this.nbElems; ++i2) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<").append(this.keys[i2]).append(",");
                if (this.values != null) {
                    sb.append(this.values[i2]);
                } else {
                    sb.append("null");
                }
                sb.append(">");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private Page<K, V> addSubTreeElement(long revision, K key, int pos) {
        PersistedLeaf<K, V> newLeaf = new PersistedLeaf<K, V>(this.btree, revision, this.nbElems + 1);
        if (this.nbElems == 0) {
            newLeaf.keys[0] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            newLeaf.keys[pos] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            System.arraycopy(this.keys, pos, newLeaf.keys, pos + 1, this.keys.length - pos);
        }
        return newLeaf;
    }

    private InsertResult<K, V> addAndSplitSubTree(long revision, K key, int pos) {
        int middle = this.btree.getPageSize() >> 1;
        PersistedLeaf<K, V> leftLeaf = null;
        PersistedLeaf<K, V> rightLeaf = null;
        if (pos <= middle) {
            leftLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle + 1);
            System.arraycopy(this.keys, 0, leftLeaf.keys, 0, pos);
            leftLeaf.keys[pos] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            System.arraycopy(this.keys, pos, leftLeaf.keys, pos + 1, middle - pos);
            rightLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.keys, middle, rightLeaf.keys, 0, middle);
        } else {
            leftLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.keys, 0, leftLeaf.keys, 0, middle);
            rightLeaf = new PersistedLeaf<K, V>(this.btree, revision, middle + 1);
            int rightPos = pos - middle;
            System.arraycopy(this.keys, middle, rightLeaf.keys, 0, rightPos);
            rightLeaf.keys[rightPos] = new PersistedKeyHolder(this.btree.getKeySerializer(), key);
            System.arraycopy(this.keys, pos, rightLeaf.keys, rightPos + 1, this.nbElems - pos);
        }
        Object pivot = rightLeaf.keys[0].getKey();
        SplitResult result = new SplitResult(pivot, leftLeaf, rightLeaf);
        return result;
    }

    @Override
    public KeyCursor<K> browseKeys(ReadTransaction<K, K> transaction, ParentPos<K, K>[] stack, int depth) {
        int pos = 0;
        KeyCursor<K> cursor = null;
        if (this.nbElems == 0) {
            stack[depth] = new ParentPos(null, -1);
            return new KeyCursor<K>(transaction, stack, depth);
        }
        ParentPos parentPos = new ParentPos(this, pos);
        stack[depth] = parentPos;
        cursor = new KeyCursor<K>(transaction, stack, depth);
        return cursor;
    }

    void _clearValues_() {
        this.values = null;
    }

    @Override
    public String dumpPage(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs);
        if (this.nbElems > 0) {
            boolean isFirst = true;
            for (int i2 = 0; i2 < this.nbElems; ++i2) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<").append(this.keys[i2]).append(",");
                if (this.values != null) {
                    sb.append(this.values[i2]);
                } else {
                    sb.append("null");
                }
                sb.append(">");
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

