/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectDecoder;
import org.apache.directory.api.ldap.extras.extended.gracefulDisconnect.GracefulDisconnectResponse;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulDisconnectResponseDecorator
extends ExtendedResponseDecorator<GracefulDisconnectResponse>
implements GracefulDisconnectResponse {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulDisconnectResponseDecorator.class);
    private int gracefulDisconnectSequenceLength;
    private int replicatedContextsLength;
    private List<byte[]> ldapUrlBytes;
    private GracefulDisconnectResponse gracefulDisconnectResponse;

    public GracefulDisconnectResponseDecorator(LdapApiService codec, GracefulDisconnectResponse decoratedMessage) {
        super(codec, decoratedMessage);
        this.gracefulDisconnectResponse = decoratedMessage;
    }

    @Override
    public byte[] getResponseValue() {
        if (this.responseValue == null) {
            try {
                this.responseValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err(I18n.ERR_08216_GRACEFUL_SHUTDOWN_PAYLOAD_ENCODING_FAILED, new Object[0]), e);
                throw new RuntimeException(e);
            }
        }
        return this.responseValue;
    }

    @Override
    public void setResponseValue(byte[] responseValue) {
        GracefulDisconnectDecoder decoder = new GracefulDisconnectDecoder();
        try {
            if (responseValue != null) {
                decoder.decode(responseValue);
                this.responseValue = new byte[responseValue.length];
                System.arraycopy(responseValue, 0, this.responseValue, 0, responseValue.length);
            } else {
                this.responseValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_08219_RESPONSE_DECODING_FAILED, new Object[0]), e);
        }
    }

    @Override
    public int getDelay() {
        return this.gracefulDisconnectResponse.getDelay();
    }

    @Override
    public void setDelay(int delay) {
        this.gracefulDisconnectResponse.setDelay(delay);
    }

    @Override
    public int getTimeOffline() {
        return this.gracefulDisconnectResponse.getTimeOffline();
    }

    @Override
    public void setTimeOffline(int timeOffline) {
        this.gracefulDisconnectResponse.setTimeOffline(timeOffline);
    }

    @Override
    public Referral getReplicatedContexts() {
        return this.gracefulDisconnectResponse.getReplicatedContexts();
    }

    @Override
    public void addReplicatedContexts(String replicatedContext) {
        this.gracefulDisconnectResponse.getReplicatedContexts().addLdapUrl(replicatedContext);
    }

    int computeLengthInternal() {
        this.gracefulDisconnectSequenceLength = 0;
        if (this.gracefulDisconnectResponse.getTimeOffline() != 0) {
            this.gracefulDisconnectSequenceLength += 2 + BerValue.getNbBytes(this.gracefulDisconnectResponse.getTimeOffline());
        }
        if (this.gracefulDisconnectResponse.getDelay() != 0) {
            this.gracefulDisconnectSequenceLength += 2 + BerValue.getNbBytes(this.gracefulDisconnectResponse.getDelay());
        }
        if (this.gracefulDisconnectResponse.getReplicatedContexts() != null && !this.gracefulDisconnectResponse.getReplicatedContexts().getLdapUrls().isEmpty()) {
            this.replicatedContextsLength = 0;
            this.ldapUrlBytes = new ArrayList<byte[]>(this.gracefulDisconnectResponse.getReplicatedContexts().getLdapUrls().size());
            for (String replicatedContext : this.gracefulDisconnectResponse.getReplicatedContexts().getLdapUrls()) {
                byte[] bytes = Strings.getBytesUtf8(replicatedContext);
                this.ldapUrlBytes.add(bytes);
                int ldapUrlLength = bytes.length;
                this.replicatedContextsLength += 1 + TLV.getNbBytes(ldapUrlLength) + ldapUrlLength;
            }
            this.gracefulDisconnectSequenceLength += 1 + TLV.getNbBytes(this.replicatedContextsLength) + this.replicatedContextsLength;
        }
        return 1 + TLV.getNbBytes(this.gracefulDisconnectSequenceLength) + this.gracefulDisconnectSequenceLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes(this.gracefulDisconnectSequenceLength));
        if (this.gracefulDisconnectResponse.getTimeOffline() != 0) {
            BerValue.encode(bb, this.gracefulDisconnectResponse.getTimeOffline());
        }
        if (this.gracefulDisconnectResponse.getDelay() != 0) {
            bb.put((byte)-128);
            bb.put((byte)TLV.getNbBytes(this.gracefulDisconnectResponse.getDelay()));
            bb.put(BerValue.getBytes(this.gracefulDisconnectResponse.getDelay()));
        }
        if (this.gracefulDisconnectResponse.getReplicatedContexts() != null && !this.gracefulDisconnectResponse.getReplicatedContexts().getLdapUrls().isEmpty()) {
            bb.put(UniversalTag.SEQUENCE.getValue());
            bb.put(TLV.getBytes(this.replicatedContextsLength));
            for (byte[] replicatedContext : this.ldapUrlBytes) {
                BerValue.encode(bb, replicatedContext);
            }
        }
        return bb;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Graceful Disconnect extended operation");
        sb.append("    TimeOffline : ").append(this.gracefulDisconnectResponse.getTimeOffline()).append('\n');
        sb.append("    Delay : ").append(this.gracefulDisconnectResponse.getDelay()).append('\n');
        if (this.gracefulDisconnectResponse.getReplicatedContexts() != null && !this.gracefulDisconnectResponse.getReplicatedContexts().getLdapUrls().isEmpty()) {
            sb.append("    Replicated contexts :");
            for (String url : this.gracefulDisconnectResponse.getReplicatedContexts().getLdapUrls()) {
                sb.append("\n        ").append(url);
            }
        }
        return sb.toString();
    }
}

