/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras;

import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdPolicyHintsFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdShowDeletedFactory;
import org.apache.directory.api.ldap.extras.controls.changeNotifications_impl.ChangeNotificationsFactory;
import org.apache.directory.api.ldap.extras.controls.permissiveModify_impl.PermissiveModifyFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory;
import org.apache.directory.api.ldap.extras.controls.transaction_impl.TransactionSpecificationFactory;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewRequestFactory;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewResponseFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.startTls.StartTlsFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.startTransaction.StartTransactionFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ExtrasBundleActivator
implements BundleActivator {
    private ServiceTracker<LdapApiService, LdapApiService> serviceTracker;

    public void start(BundleContext context) throws Exception {
        LdapApiServiceTracker ldapApiServiceTracker = new LdapApiServiceTracker(context);
        this.serviceTracker = new ServiceTracker(context, LdapApiService.class, (ServiceTrackerCustomizer)ldapApiServiceTracker);
        this.serviceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceTracker.close();
    }

    class LdapApiServiceTracker
    implements ServiceTrackerCustomizer<LdapApiService, LdapApiService> {
        private BundleContext context;

        LdapApiServiceTracker(BundleContext context) {
            this.context = context;
        }

        public LdapApiService addingService(ServiceReference<LdapApiService> reference) {
            LdapApiService ldapApiService = (LdapApiService)this.context.getService(reference);
            this.registerExtrasControls(ldapApiService);
            this.registerExtrasExtendedOps(ldapApiService);
            return ldapApiService;
        }

        public void modifiedService(ServiceReference<LdapApiService> reference, LdapApiService ldapApiService) {
        }

        public void removedService(ServiceReference<LdapApiService> reference, LdapApiService ldapApiService) {
            this.unregisterExtrasControls(ldapApiService);
            this.unregisterExtrasExtendedOps(ldapApiService);
        }

        private void registerExtrasExtendedOps(LdapApiService codec) {
            CancelFactory cancelFactory = new CancelFactory(codec);
            codec.registerExtendedRequest(cancelFactory);
            CertGenerationFactory certGenerationFactory = new CertGenerationFactory(codec);
            codec.registerExtendedRequest(certGenerationFactory);
            EndTransactionFactory endTransactionFactory = new EndTransactionFactory(codec);
            codec.registerExtendedRequest(endTransactionFactory);
            GracefulDisconnectFactory gracefulDisconnectFactory = new GracefulDisconnectFactory(codec);
            codec.registerExtendedRequest(gracefulDisconnectFactory);
            GracefulShutdownFactory gracefulShutdownFactory = new GracefulShutdownFactory(codec);
            codec.registerExtendedRequest(gracefulShutdownFactory);
            PasswordModifyFactory passwordModifyFactory = new PasswordModifyFactory(codec);
            codec.registerExtendedRequest(passwordModifyFactory);
            StartTlsFactory startTlsFactory = new StartTlsFactory(codec);
            codec.registerExtendedRequest(startTlsFactory);
            StartTransactionFactory startTransactionFactory = new StartTransactionFactory(codec);
            codec.registerExtendedRequest(startTransactionFactory);
            StoredProcedureFactory storedProcedureFactory = new StoredProcedureFactory(codec);
            codec.registerExtendedRequest(storedProcedureFactory);
            WhoAmIFactory whoAmIFactory = new WhoAmIFactory(codec);
            codec.registerExtendedRequest(whoAmIFactory);
        }

        private void unregisterExtrasControls(LdapApiService codec) {
            codec.unregisterControl("1.2.840.113556.1.4.841");
            codec.unregisterControl("1.2.840.113556.1.4.417");
            codec.unregisterControl("1.2.840.113556.1.4.2239");
            codec.unregisterControl("1.2.840.113556.1.4.528");
            codec.unregisterControl("1.3.6.1.4.1.42.2.27.8.5.1");
            codec.unregisterControl("1.2.840.113556.1.4.1413");
            codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.3");
            codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.1");
            codec.unregisterControl("1.3.6.1.4.1.4203.1.9.1.2");
            codec.unregisterControl("1.3.6.1.1.21.2");
            codec.unregisterControl("2.16.840.1.113730.3.4.9");
            codec.unregisterControl("2.16.840.1.113730.3.4.10");
        }

        private void unregisterExtrasExtendedOps(LdapApiService codec) {
            codec.unregisterExtendedRequest("1.3.6.1.1.8");
            codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.8");
            codec.unregisterExtendedRequest("1.3.6.1.1.21.3");
            codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.3");
            codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.5");
            codec.unregisterExtendedRequest("1.3.6.1.4.1.4203.1.11.1");
            codec.unregisterExtendedRequest("1.3.6.1.4.1.1466.20037");
            codec.unregisterExtendedRequest("1.3.6.1.1.21.1");
            codec.unregisterExtendedRequest("1.3.6.1.4.1.18060.0.1.6");
            codec.unregisterExtendedRequest("1.3.6.1.4.1.4203.1.11.3");
        }

        private void registerExtrasControls(LdapApiService codec) {
            AdDirSyncFactory adDirSyncFactory = new AdDirSyncFactory(codec);
            codec.registerControl(adDirSyncFactory);
            AdShowDeletedFactory adDeletedFactory = new AdShowDeletedFactory(codec);
            codec.registerControl(adDeletedFactory);
            AdPolicyHintsFactory adPolicyHintsFactory = new AdPolicyHintsFactory(codec);
            codec.registerControl(adPolicyHintsFactory);
            ChangeNotificationsFactory changeNotificationsFactory = new ChangeNotificationsFactory(codec);
            codec.registerControl(changeNotificationsFactory);
            PasswordPolicyFactory passwordPolicyFactory = new PasswordPolicyFactory(codec);
            codec.registerControl(passwordPolicyFactory);
            PermissiveModifyFactory permissiveModifyFactory = new PermissiveModifyFactory(codec);
            codec.registerControl(permissiveModifyFactory);
            SyncDoneValueFactory syncDoneValuefactory = new SyncDoneValueFactory(codec);
            codec.registerControl(syncDoneValuefactory);
            SyncRequestValueFactory syncRequestValueFactory = new SyncRequestValueFactory(codec);
            codec.registerControl(syncRequestValueFactory);
            SyncStateValueFactory syncStateValuefactory = new SyncStateValueFactory(codec);
            codec.registerControl(syncStateValuefactory);
            TransactionSpecificationFactory transactionSpecificationfactory = new TransactionSpecificationFactory(codec);
            codec.registerControl(transactionSpecificationfactory);
            VirtualListViewRequestFactory virtualListViewRequestFactory = new VirtualListViewRequestFactory(codec);
            codec.registerControl(virtualListViewRequestFactory);
            VirtualListViewResponseFactory virtualListViewResponseFactory = new VirtualListViewResponseFactory(codec);
            codec.registerControl(virtualListViewResponseFactory);
        }
    }
}

