/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.SubstringFilter;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreInitial
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreInitial.class);

    public StoreInitial() {
        super("Store an initial value");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        SubstringFilter substringFilter = (SubstringFilter)searchRequestDecorator.getTerminalFilter();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04108, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        substringFilter.setInitialSubstrings(Strings.utf8ToString(tlv.getValue().getData()));
        searchRequestDecorator.unstackFilters(container);
    }
}

