/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.csn.Csn;
import org.apache.directory.shared.ldap.model.csn.CsnFactory;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.LdapLdifException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.schemaextractor.SchemaLdifExtractor;
import org.apache.directory.shared.ldap.schemaextractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schemaextractor.impl.ResourceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaLdifToPartitionExtractor
implements SchemaLdifExtractor {
    private static final String BASE_PATH = "";
    private static final Logger LOG = LoggerFactory.getLogger(SchemaLdifToPartitionExtractor.class);
    private static final Pattern EXTRACT_PATTERN = Pattern.compile(".*schema[/\\Q\\\\E]ou=schema.*\\.ldif");
    private final CsnFactory csnFactory = new CsnFactory(0);
    private boolean extracted;
    private final SchemaManager schemaManager;
    private final Partition partition;

    public SchemaLdifToPartitionExtractor(SchemaManager schemaManager, Partition partition) throws LdapException {
        this.schemaManager = schemaManager;
        this.partition = partition;
        Dn dn = new Dn(schemaManager, "ou=schema");
        HasEntryOperationContext hasEntryContext = new HasEntryOperationContext(null, dn);
        if (partition.hasEntry(hasEntryContext)) {
            LOG.info("Schema entry 'ou=schema' exists: extracted state set to true.");
            this.extracted = true;
        } else {
            LOG.info("Schema entry 'ou=schema' does NOT exist: extracted state set to false.");
            this.extracted = false;
        }
    }

    @Override
    public boolean isExtracted() {
        return this.extracted;
    }

    @Override
    public void extractOrCopy(boolean overwrite) throws IOException {
        Map<String, Boolean> resources = ResourceMap.getResources(EXTRACT_PATTERN);
        resources = new TreeMap<String, Boolean>(resources);
        if (!this.extracted || overwrite) {
            for (Map.Entry<String, Boolean> entry : resources.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    this.addFromClassLoader(entry.getKey());
                    continue;
                }
                File resource = new File(entry.getKey());
                this.addLdifFile(resource);
            }
            this.extracted = true;
        }
    }

    @Override
    public void extractOrCopy() throws IOException {
        this.extractOrCopy(false);
    }

    private void addLdifFile(File source) throws IOException {
        LOG.debug("copyFile(): source = {}", (Object)source);
        if (!source.getParentFile().exists()) {
            throw new FileNotFoundException(I18n.err(I18n.ERR_08002, source.getAbsolutePath()));
        }
        FileInputStream in = new FileInputStream(source);
        this.addFromStream(in, source.getAbsolutePath());
    }

    private void addFromClassLoader(String resource) throws IOException {
        InputStream in = DefaultSchemaLdifExtractor.getUniqueResourceAsStream(resource, "LDIF file in schema repository");
        this.addFromStream(in, resource);
    }

    private void addFromStream(InputStream in, String source) throws IOException {
        try {
            LdifReader ldifReader = new LdifReader(in);
            boolean first = true;
            LdifEntry ldifEntry = null;
            while (ldifReader.hasNext()) {
                if (first) {
                    ldifEntry = ldifReader.next();
                    if (ldifEntry.get("entryUUID") == null) {
                        UUID entryUuid = UUID.randomUUID();
                        ldifEntry.addAttribute("entryUUID", entryUuid.toString());
                    }
                    if (ldifEntry.get("entryCSN") == null) {
                        Csn csn = this.csnFactory.newInstance();
                        ldifEntry.addAttribute("entryCSN", csn.toString());
                    }
                    first = false;
                    continue;
                }
                String msg = I18n.err(I18n.ERR_08003, source);
                LOG.error(msg);
                throw new InvalidObjectException(msg);
            }
            ldifReader.close();
            DefaultEntry entry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
            AddOperationContext addContext = new AddOperationContext(null, entry);
            this.partition.add(addContext);
        }
        catch (LdapLdifException ne) {
            String msg = I18n.err(I18n.ERR_08004, source, ne.getLocalizedMessage());
            LOG.error(msg);
            throw new InvalidObjectException(msg);
        }
        catch (LdapException ne) {
            String msg = I18n.err(I18n.ERR_08004, source, ne.getLocalizedMessage());
            LOG.error(msg);
            throw new InvalidObjectException(msg);
        }
    }
}

