/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.filtering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.entry.ClonedServerEntrySearch;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchingOperationContext;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.model.schema.UsageEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEntryFilteringCursor
extends AbstractCursor<Entry>
implements EntryFilteringCursor {
    private static final Logger log = LoggerFactory.getLogger(BaseEntryFilteringCursor.class);
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final Cursor<Entry> wrapped;
    private final SearchingOperationContext operationContext;
    private final List<EntryFilter> filters;
    private Entry prefetched;

    public BaseEntryFilteringCursor(Cursor<Entry> wrapped, SearchingOperationContext operationContext, EntryFilter filter) {
        this(wrapped, operationContext, Collections.singletonList(filter));
    }

    public BaseEntryFilteringCursor(Cursor<Entry> wrapped, SearchingOperationContext operationContext) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating BaseEntryFilteringCursor {}", (Object)this);
        }
        this.wrapped = wrapped;
        this.operationContext = operationContext;
        this.filters = new ArrayList<EntryFilter>();
    }

    public BaseEntryFilteringCursor(Cursor<Entry> wrapped, SearchingOperationContext operationContext, List<EntryFilter> filters) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating BaseEntryFilteringCursor {}", (Object)this);
        }
        this.wrapped = wrapped;
        this.operationContext = operationContext;
        this.filters = new ArrayList<EntryFilter>();
        this.filters.addAll(filters);
    }

    public boolean isAbandoned() {
        return this.getOperationContext().isAbandoned();
    }

    public void setAbandoned(boolean abandoned) {
        this.getOperationContext().setAbandoned(abandoned);
        if (abandoned) {
            log.info("Cursor has been abandoned.");
        }
    }

    @Override
    public boolean addEntryFilter(EntryFilter filter) {
        return this.filters.add(filter);
    }

    public boolean removeEntryFilter(EntryFilter filter) {
        return this.filters.remove(filter);
    }

    @Override
    public List<EntryFilter> getEntryFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    @Override
    public SearchingOperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public void after(Entry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws Exception {
        this.wrapped.afterLast();
        this.prefetched = null;
    }

    @Override
    public boolean available() {
        return this.prefetched != null;
    }

    @Override
    public void before(Entry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws Exception {
        this.wrapped.beforeFirst();
        this.prefetched = null;
    }

    @Override
    public void close() throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing BaseEntryFilteringCursor {}", (Object)this);
        }
        this.wrapped.close();
        this.prefetched = null;
    }

    @Override
    public void close(Exception reason) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing BaseEntryFilteringCursor {}", (Object)this);
        }
        this.wrapped.close(reason);
        this.prefetched = null;
    }

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.wrapped.setClosureMonitor(monitor);
    }

    @Override
    public boolean first() throws Exception {
        if (this.getOperationContext().isAbandoned()) {
            log.info("Cursor has been abandoned.");
            this.close();
            throw new OperationAbandonedException();
        }
        this.beforeFirst();
        return this.next();
    }

    @Override
    public Entry get() throws Exception {
        if (this.available()) {
            return this.prefetched;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean isClosed() throws Exception {
        return this.wrapped.isClosed();
    }

    @Override
    public boolean last() throws Exception {
        if (this.getOperationContext().isAbandoned()) {
            log.info("Cursor has been abandoned.");
            this.close();
            throw new OperationAbandonedException();
        }
        this.afterLast();
        return this.previous();
    }

    private void filterContents(Entry entry) throws Exception {
        boolean returnAll;
        boolean typesOnly = this.getOperationContext().isTypesOnly();
        boolean bl = returnAll = (this.getOperationContext().getReturningAttributes() == null || this.getOperationContext().isAllOperationalAttributes() && this.getOperationContext().isAllUserAttributes()) && !typesOnly;
        if (returnAll) {
            return;
        }
        Entry originalEntry = ((ClonedServerEntry)entry).getOriginalEntry();
        if (this.getOperationContext().isNoAttributes()) {
            for (Attribute attribute : originalEntry.getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                entry.remove(entry.get(attributeType));
            }
            return;
        }
        if (this.getOperationContext().isAllUserAttributes()) {
            for (Attribute attribute : originalEntry.getAttributes()) {
                boolean isNotUserAttribute;
                AttributeType attributeType = attribute.getAttributeType();
                boolean isNotRequested = true;
                for (AttributeTypeOptions attrOptions : this.getOperationContext().getReturningAttributes()) {
                    if (!attrOptions.getAttributeType().equals(attributeType) && !attrOptions.getAttributeType().isAncestorOf(attributeType)) continue;
                    isNotRequested = false;
                    break;
                }
                boolean bl2 = isNotUserAttribute = attributeType.getUsage() != UsageEnum.USER_APPLICATIONS;
                if (isNotRequested && isNotUserAttribute) {
                    entry.removeAttributes(attributeType);
                    continue;
                }
                if (!typesOnly) continue;
                entry.get(attributeType).clear();
            }
            return;
        }
        if (this.getOperationContext().isAllOperationalAttributes()) {
            for (Attribute attribute : originalEntry.getAttributes()) {
                boolean isUserAttribute;
                AttributeType attributeType = attribute.getAttributeType();
                boolean isNotRequested = true;
                for (AttributeTypeOptions attrOptions : this.getOperationContext().getReturningAttributes()) {
                    if (!attrOptions.getAttributeType().equals(attributeType) && !attrOptions.getAttributeType().isAncestorOf(attributeType)) continue;
                    isNotRequested = false;
                    break;
                }
                boolean bl3 = isUserAttribute = attributeType.getUsage() == UsageEnum.USER_APPLICATIONS;
                if (isNotRequested && isUserAttribute) {
                    entry.removeAttributes(attributeType);
                    continue;
                }
                if (!typesOnly) continue;
                entry.get(attributeType).clear();
            }
            return;
        }
        if (this.getOperationContext().getReturningAttributes() != null) {
            for (Attribute attribute : originalEntry.getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                boolean isNotRequested = true;
                for (AttributeTypeOptions attrOptions : this.getOperationContext().getReturningAttributes()) {
                    if (!attrOptions.getAttributeType().equals(attributeType) && !attrOptions.getAttributeType().isAncestorOf(attributeType)) continue;
                    isNotRequested = false;
                    break;
                }
                if (isNotRequested) {
                    entry.removeAttributes(attributeType);
                    continue;
                }
                if (!typesOnly) continue;
                entry.get(attributeType).clear();
            }
        }
    }

    @Override
    public boolean next() throws Exception {
        if (this.getOperationContext().isAbandoned()) {
            log.info("Cursor has been abandoned.");
            this.close();
            throw new OperationAbandonedException();
        }
        Entry tempResult = null;
        block0: while (this.wrapped.next()) {
            boolean accepted = true;
            Entry tempEntry = this.wrapped.get();
            if (tempEntry == null) continue;
            tempResult = tempEntry instanceof ClonedServerEntry ? tempEntry : new ClonedServerEntrySearch(tempEntry);
            if (this.filters.isEmpty()) {
                this.prefetched = tempResult;
                this.filterContents(this.prefetched);
                return true;
            }
            if (this.filters.size() == 1 && this.filters.get(0).accept(this.getOperationContext(), tempResult)) {
                this.prefetched = tempResult;
                this.filterContents(this.prefetched);
                return true;
            }
            for (EntryFilter filter : this.filters) {
                if (filter.accept(this.getOperationContext(), tempResult)) continue;
                continue block0;
            }
            this.prefetched = tempResult;
            this.filterContents(this.prefetched);
            return true;
        }
        this.prefetched = null;
        return false;
    }

    @Override
    public boolean previous() throws Exception {
        if (this.getOperationContext().isAbandoned()) {
            log.info("Cursor has been abandoned.");
            this.close();
            throw new OperationAbandonedException();
        }
        ClonedServerEntrySearch tempResult = null;
        block0: while (this.wrapped.previous()) {
            boolean accepted = true;
            Entry entry = this.wrapped.get();
            if (entry == null) continue;
            tempResult = new ClonedServerEntrySearch(entry);
            if (this.filters.isEmpty()) {
                this.prefetched = tempResult;
                this.filterContents(this.prefetched);
                return true;
            }
            if (this.filters.size() == 1 && this.filters.get(0).accept(this.getOperationContext(), tempResult)) {
                this.prefetched = tempResult;
                this.filterContents(this.prefetched);
                return true;
            }
            for (EntryFilter filter : this.filters) {
                if (filter.accept(this.getOperationContext(), tempResult)) continue;
                continue block0;
            }
            this.prefetched = tempResult;
            this.filterContents(this.prefetched);
            return true;
        }
        this.prefetched = null;
        return false;
    }
}

