/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.directory.server.core.DefaultOperationManager;
import org.apache.directory.server.core.admin.AdministrativePointInterceptor;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.ReferralManager;
import org.apache.directory.server.core.api.administrative.AccessControlAdministrativePoint;
import org.apache.directory.server.core.api.administrative.CollectiveAttributeAdministrativePoint;
import org.apache.directory.server.core.api.administrative.SubschemaAdministrativePoint;
import org.apache.directory.server.core.api.administrative.TriggerExecutionAdministrativePoint;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.api.changelog.ChangeLogEvent;
import org.apache.directory.server.core.api.changelog.Tag;
import org.apache.directory.server.core.api.changelog.TaggableSearchableChangeLogStore;
import org.apache.directory.server.core.api.event.EventService;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.journal.Journal;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.api.subtree.SubentryCache;
import org.apache.directory.server.core.api.subtree.SubtreeEvaluator;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authn.ppolicy.PpolicyConfigContainer;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.changelog.ChangeLogInterceptor;
import org.apache.directory.server.core.changelog.DefaultChangeLog;
import org.apache.directory.server.core.collective.CollectiveAttributeInterceptor;
import org.apache.directory.server.core.event.EventInterceptor;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.journal.DefaultJournal;
import org.apache.directory.server.core.journal.JournalInterceptor;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.referral.ReferralInterceptor;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.server.core.shared.DefaultCoreSession;
import org.apache.directory.server.core.shared.DefaultDnFactory;
import org.apache.directory.server.core.shared.partition.DefaultPartitionNexus;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.core.trigger.TriggerInterceptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.csn.Csn;
import org.apache.directory.shared.ldap.model.csn.CsnFactory;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.DnUtils;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.tree.DnNode;
import org.apache.directory.shared.util.DateUtils;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.exception.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDirectoryService
implements DirectoryService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDirectoryService.class);
    private SchemaPartition schemaPartition;
    private SchemaManager schemaManager;
    private LdapApiService ldapCodecService = LdapApiServiceFactory.getSingleton();
    private DefaultPartitionNexus partitionNexus;
    private boolean firstStart;
    private boolean started;
    private ChangeLog changeLog;
    private Journal journal;
    private OperationManager operationManager = new DefaultOperationManager(this);
    private Dn adminDn;
    private CoreSession adminSession;
    private ReferralManager referralManager;
    private boolean passwordHidden = false;
    private CsnFactory csnFactory;
    private int replicaId;
    private static final String PARTIAL_IMPL_WARNING = "WARNING: the changelog is only partially operational and will revert\nstate without consideration of who made the original change.  All reverting changes are made by the admin user.\n Furthermore the used controls are not at all taken into account";
    private long syncPeriodMillis = 15000L;
    private static final long DEFAULT_SYNC_PERIOD = 15000L;
    private Thread workerThread;
    private SynchWorker worker = new SynchWorker();
    public static final int MAX_SIZE_LIMIT_DEFAULT = 100;
    public static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private String instanceId;
    private InstanceLayout instanceLayout;
    private boolean exitVmOnShutdown = true;
    private boolean shutdownHookEnabled = true;
    private boolean allowAnonymousAccess = true;
    private boolean accessControlEnabled;
    private boolean denormalizeOpAttrsEnabled;
    private List<Interceptor> interceptors;
    private Map<String, Interceptor> interceptorNames;
    private ReadWriteLock interceptorsLock = new ReentrantReadWriteLock();
    private Lock readLock = this.interceptorsLock.readLock();
    private Lock writeLock = this.interceptorsLock.writeLock();
    private Map<OperationEnum, List<String>> operationInterceptors;
    private Partition systemPartition;
    private Set<Partition> partitions = new HashSet<Partition>();
    private List<? extends LdifEntry> testEntries = new ArrayList<LdifEntry>();
    private EventService eventService;
    private int maxPDUSize = Integer.MAX_VALUE;
    private String contextCsn;
    private RandomAccessFile lockFile = null;
    private static final String LOCK_FILE_NAME = ".dirservice.lock";
    private CacheService cacheService;
    private DnNode<AccessControlAdministrativePoint> accessControlAPCache;
    private DnNode<CollectiveAttributeAdministrativePoint> collectiveAttributeAPCache;
    private DnNode<SubschemaAdministrativePoint> subschemaAPCache;
    private DnNode<TriggerExecutionAdministrativePoint> triggerExecutionAPCache;
    private DnFactory dnFactory;
    SubentryCache subentryCache = new SubentryCache();
    private SubtreeEvaluator evaluator;

    public DefaultDirectoryService() throws Exception {
        this.changeLog = new DefaultChangeLog();
        this.journal = new DefaultJournal();
        this.csnFactory = new CsnFactory(this.replicaId);
        this.evaluator = new SubtreeEvaluator(this.schemaManager);
    }

    @Override
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public Set<? extends Partition> getPartitions() {
        HashSet<Partition> cloned = new HashSet<Partition>();
        cloned.addAll(this.partitions);
        return cloned;
    }

    @Override
    public void setPartitions(Set<? extends Partition> partitions) {
        HashSet<Partition> cloned = new HashSet<Partition>();
        cloned.addAll(partitions);
        HashSet<String> names = new HashSet<String>();
        for (Partition partition : cloned) {
            String id = partition.getId();
            if (names.contains(id)) {
                LOG.warn("Encountered duplicate partition {} identifier.", (Object)id);
            }
            names.add(id);
        }
        this.partitions = cloned;
    }

    @Override
    public boolean isAccessControlEnabled() {
        return this.accessControlEnabled;
    }

    @Override
    public void setAccessControlEnabled(boolean accessControlEnabled) {
        this.accessControlEnabled = accessControlEnabled;
    }

    @Override
    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    @Override
    public void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
        this.allowAnonymousAccess = enableAnonymousAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Interceptor> getInterceptors() {
        ArrayList<Interceptor> cloned = new ArrayList<Interceptor>();
        try {
            this.readLock.lock();
            cloned.addAll(this.interceptors);
            ArrayList<Interceptor> arrayList = cloned;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getInterceptors(OperationEnum operation) {
        ArrayList<String> cloned = new ArrayList<String>();
        try {
            this.readLock.lock();
            cloned.addAll((Collection)this.operationInterceptors.get((Object)operation));
            ArrayList<String> arrayList = cloned;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOperationsList() {
        try {
            this.writeLock.lock();
            this.operationInterceptors = new ConcurrentHashMap<OperationEnum, List<String>>();
            for (OperationEnum operation : OperationEnum.getOperations()) {
                ArrayList<String> operationList = new ArrayList<String>();
                for (Interceptor interceptor : this.interceptors) {
                    this.gatherInterceptors(interceptor, interceptor.getClass(), operation, operationList);
                }
                this.operationInterceptors.put(operation, operationList);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void gatherInterceptors(Interceptor interceptor, Class<?> interceptorClz, OperationEnum operation, List<String> selectedInterceptorList) {
        Method[] methods;
        if (interceptorClz == null || interceptorClz == BaseInterceptor.class) {
            return;
        }
        for (Method method : methods = interceptorClz.getDeclaredMethods()) {
            Class<?>[] param = method.getParameterTypes();
            boolean hasCorrestSig = false;
            if (param == null || param.length > 1 || param.length == 0 || !OperationContext.class.isAssignableFrom(param[0]) || !(hasCorrestSig = true) || !method.getName().equals(operation.getMethodName())) continue;
            selectedInterceptorList.add(interceptor.getName());
            break;
        }
        this.gatherInterceptors(interceptor, interceptorClz.getSuperclass(), operation, selectedInterceptorList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInterceptor(Interceptor interceptor, int position) throws LdapException {
        interceptor.init(this);
        try {
            this.writeLock.lock();
            block3: for (OperationEnum operation : OperationEnum.getOperations()) {
                Method[] methods;
                List<String> operationList = this.operationInterceptors.get((Object)operation);
                for (Method method : methods = interceptor.getClass().getDeclaredMethods()) {
                    if (!method.getName().equals(operation.getMethodName())) continue;
                    if (position == -1) {
                        operationList.add(interceptor.getName());
                        continue block3;
                    }
                    operationList.add(position, interceptor.getName());
                    continue block3;
                }
            }
            this.interceptorNames.put(interceptor.getName(), interceptor);
            if (position == -1) {
                this.interceptors.add(interceptor);
            } else {
                this.interceptors.add(position, interceptor);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOperationsList(String interceptorName) {
        Interceptor interceptor = this.interceptorNames.get(interceptorName);
        try {
            this.writeLock.lock();
            block3: for (OperationEnum operation : OperationEnum.getOperations()) {
                Method[] methods;
                List<String> operationList = this.operationInterceptors.get((Object)operation);
                for (Method method : methods = interceptor.getClass().getDeclaredMethods()) {
                    if (!method.getName().equals(operation.getMethodName())) continue;
                    operationList.remove(interceptor.getName());
                    continue block3;
                }
            }
            this.interceptorNames.remove(interceptorName);
            this.interceptors.remove(interceptor);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void setInterceptors(List<Interceptor> interceptors) {
        HashMap<String, Interceptor> interceptorNames = new HashMap<String, Interceptor>();
        for (Interceptor interceptor : interceptors) {
            if (interceptorNames.containsKey(interceptor.getName())) {
                LOG.warn("Encountered duplicate definitions for {} interceptor", (Object)interceptor.getName());
                continue;
            }
            interceptorNames.put(interceptor.getName(), interceptor);
        }
        this.interceptors = interceptors;
        this.interceptorNames = interceptorNames;
        this.initOperationsList();
    }

    private void initInterceptors() throws LdapException {
        for (Interceptor interceptor : this.interceptors) {
            interceptor.init(this);
        }
    }

    @Override
    public List<LdifEntry> getTestEntries() {
        ArrayList<LdifEntry> cloned = new ArrayList<LdifEntry>();
        cloned.addAll(this.testEntries);
        return cloned;
    }

    @Override
    public void setTestEntries(List<? extends LdifEntry> testEntries) {
        ArrayList<? extends LdifEntry> cloned = new ArrayList<LdifEntry>();
        cloned.addAll(testEntries);
        this.testEntries = testEntries;
    }

    @Override
    public InstanceLayout getInstanceLayout() {
        return this.instanceLayout;
    }

    @Override
    public void setInstanceLayout(InstanceLayout instanceLayout) throws IOException {
        this.instanceLayout = instanceLayout;
        if (!instanceLayout.getInstanceDirectory().exists() && !instanceLayout.getInstanceDirectory().mkdirs()) {
            throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, instanceLayout.getInstanceDirectory()));
        }
        if (!instanceLayout.getLogDirectory().exists() && !instanceLayout.getLogDirectory().mkdirs()) {
            throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, instanceLayout.getLogDirectory()));
        }
        if (!instanceLayout.getRunDirectory().exists() && !instanceLayout.getRunDirectory().mkdirs()) {
            throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, instanceLayout.getRunDirectory()));
        }
        if (!instanceLayout.getPartitionsDirectory().exists() && !instanceLayout.getPartitionsDirectory().mkdirs()) {
            throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, instanceLayout.getPartitionsDirectory()));
        }
        if (!instanceLayout.getConfDirectory().exists() && !instanceLayout.getConfDirectory().mkdirs()) {
            throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, instanceLayout.getConfDirectory()));
        }
    }

    @Override
    public void setShutdownHookEnabled(boolean shutdownHookEnabled) {
        this.shutdownHookEnabled = shutdownHookEnabled;
    }

    @Override
    public boolean isShutdownHookEnabled() {
        return this.shutdownHookEnabled;
    }

    @Override
    public void setExitVmOnShutdown(boolean exitVmOnShutdown) {
        this.exitVmOnShutdown = exitVmOnShutdown;
    }

    @Override
    public boolean isExitVmOnShutdown() {
        return this.exitVmOnShutdown;
    }

    @Override
    public void setSystemPartition(Partition systemPartition) {
        this.systemPartition = systemPartition;
    }

    @Override
    public Partition getSystemPartition() {
        return this.systemPartition;
    }

    @Override
    public boolean isDenormalizeOpAttrsEnabled() {
        return this.denormalizeOpAttrsEnabled;
    }

    @Override
    public void setDenormalizeOpAttrsEnabled(boolean denormalizeOpAttrsEnabled) {
        this.denormalizeOpAttrsEnabled = denormalizeOpAttrsEnabled;
    }

    @Override
    public ChangeLog getChangeLog() {
        return this.changeLog;
    }

    @Override
    public Journal getJournal() {
        return this.journal;
    }

    @Override
    public void setChangeLog(ChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    @Override
    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    @Override
    public void addPartition(Partition partition) throws Exception {
        partition.setSchemaManager(this.schemaManager);
        if (this.partitionNexus != null) {
            this.partitionNexus.addContextPartition(partition);
        }
        this.partitions.add(partition);
    }

    @Override
    public void removePartition(Partition partition) throws Exception {
        if (this.partitionNexus != null) {
            this.partitionNexus.removeContextPartition(partition.getSuffixDn());
        }
        this.partitions.remove(partition);
    }

    private void setDefaultInterceptorConfigurations() {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>();
        list.add(new NormalizationInterceptor());
        list.add(new AuthenticationInterceptor());
        list.add(new ReferralInterceptor());
        list.add(new AciAuthorizationInterceptor());
        list.add(new DefaultAuthorizationInterceptor());
        list.add(new AdministrativePointInterceptor());
        list.add(new ExceptionInterceptor());
        list.add(new SchemaInterceptor());
        list.add(new OperationalAttributeInterceptor());
        list.add(new CollectiveAttributeInterceptor());
        list.add(new SubentryInterceptor());
        list.add(new EventInterceptor());
        list.add(new TriggerInterceptor());
        list.add(new ChangeLogInterceptor());
        list.add(new JournalInterceptor());
        this.setInterceptors(list);
    }

    @Override
    public CoreSession getAdminSession() {
        return this.adminSession;
    }

    @Override
    public CoreSession getSession() {
        return new DefaultCoreSession(new LdapPrincipal(this.schemaManager), this);
    }

    @Override
    public CoreSession getSession(LdapPrincipal principal) {
        return new DefaultCoreSession(principal, this);
    }

    @Override
    public CoreSession getSession(Dn principalDn, byte[] credentials) throws LdapException {
        if (!this.started) {
            throw new IllegalStateException("Service has not started.");
        }
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setCredentials(credentials);
        bindContext.setDn(principalDn);
        bindContext.setInterceptors(this.getInterceptors(OperationEnum.BIND));
        this.operationManager.bind(bindContext);
        return bindContext.getSession();
    }

    @Override
    public CoreSession getSession(Dn principalDn, byte[] credentials, String saslMechanism, String saslAuthId) throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service has not started.");
        }
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setCredentials(credentials);
        bindContext.setDn(principalDn);
        bindContext.setSaslMechanism(saslMechanism);
        bindContext.setInterceptors(this.getInterceptors(OperationEnum.BIND));
        this.operationManager.bind(bindContext);
        return bindContext.getSession();
    }

    @Override
    public long revert() throws LdapException {
        if (this.changeLog == null || !this.changeLog.isEnabled()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_310, new Object[0]));
        }
        Tag latest = this.changeLog.getLatest();
        if (null != latest) {
            if (latest.getRevision() < this.changeLog.getCurrentRevision()) {
                return this.revert(latest.getRevision());
            }
            LOG.info("Ignoring request to revert without changes since the latest tag.");
            return this.changeLog.getCurrentRevision();
        }
        throw new IllegalStateException(I18n.err(I18n.ERR_311, new Object[0]));
    }

    private void moddn(Dn oldDn, Dn newDn, boolean delOldRdn) throws LdapException {
        if (oldDn.size() == 0) {
            throw new LdapNoPermissionException(I18n.err(I18n.ERR_312, new Object[0]));
        }
        Dn oldBase = oldDn.getParent();
        Dn newBase = newDn.getParent();
        Rdn newRdn = newDn.getRdn();
        Rdn oldRdn = oldDn.getRdn();
        if (oldDn.size() == newDn.size() && oldBase.equals(newBase)) {
            this.adminSession.rename(oldDn, newRdn, delOldRdn);
        } else {
            Dn target = newDn.getParent();
            if (newRdn.equals(oldRdn)) {
                this.adminSession.move(oldDn, target);
            } else {
                this.adminSession.moveAndRename(oldDn, target, new Rdn(newRdn), delOldRdn);
            }
        }
    }

    @Override
    public long revert(long revision) throws LdapException {
        if (this.changeLog == null || !this.changeLog.isEnabled()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_310, new Object[0]));
        }
        if (revision < 0L) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_239, new Object[0]));
        }
        if (revision >= this.changeLog.getChangeLogStore().getCurrentRevision()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_314, new Object[0]));
        }
        Cursor<ChangeLogEvent> cursor = this.changeLog.getChangeLogStore().findAfter(revision);
        try {
            LOG.warn(PARTIAL_IMPL_WARNING);
            cursor.afterLast();
            while (cursor.previous()) {
                ChangeLogEvent event = cursor.get();
                List<LdifEntry> reverses = event.getReverseLdifs();
                block17: for (LdifEntry reverse : reverses) {
                    switch (reverse.getChangeType().getChangeType()) {
                        case 0: {
                            this.adminSession.add((Entry)new DefaultEntry(this.schemaManager, reverse.getEntry()), true);
                            continue block17;
                        }
                        case 4: {
                            this.adminSession.delete(reverse.getDn(), true);
                            continue block17;
                        }
                        case 1: {
                            List<Modification> mods = reverse.getModifications();
                            this.adminSession.modify(reverse.getDn(), mods, true);
                            continue block17;
                        }
                        case 2: 
                        case 3: {
                            Dn forwardDn = event.getForwardLdif().getDn();
                            Dn reverseDn = reverse.getDn();
                            this.moddn(reverseDn, forwardDn, reverse.isDeleteOldRdn());
                            continue block17;
                        }
                    }
                    LOG.error(I18n.err(I18n.ERR_75, new Object[0]));
                    throw new NotImplementedException(I18n.err(I18n.ERR_76, new Object[]{reverse.getChangeType()}));
                }
            }
        }
        catch (IOException e) {
            String message = I18n.err(I18n.ERR_77, revision);
            LOG.error(message);
            throw new LdapException(message);
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), e);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
        }
        return this.changeLog.getCurrentRevision();
    }

    @Override
    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public synchronized void startup() throws Exception {
        if (this.started) {
            return;
        }
        this.lockWorkDir();
        if (this.shutdownHookEnabled) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultDirectoryService.this.shutdown();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to shut down the directory service: " + DefaultDirectoryService.this.instanceId, e);
                    }
                }
            }, "ApacheDS Shutdown Hook (" + this.instanceId + ')'));
            LOG.info("ApacheDS shutdown hook has been registered with the runtime.");
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("ApacheDS shutdown hook has NOT been registered with the runtime.  This default setting for standalone operation has been overriden.");
        }
        this.initialize();
        this.showSecurityWarnings();
        if (this.syncPeriodMillis > 0L) {
            this.workerThread = new Thread((Runnable)this.worker, "SynchWorkerThread");
            this.workerThread.start();
        }
        LookupOperationContext loc = new LookupOperationContext(this.getAdminSession());
        loc.setDn(this.systemPartition.getSuffixDn());
        loc.setAttrsId(SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry entry = this.systemPartition.lookup(loc);
        Attribute cntextCsnAt = entry.get("contextCSN");
        if (cntextCsnAt != null) {
            this.contextCsn = cntextCsnAt.getString();
        }
        this.started = true;
        if (!this.testEntries.isEmpty()) {
            this.createTestEntries();
        }
    }

    @Override
    public synchronized void sync() throws Exception {
        if (!this.started) {
            return;
        }
        this.changeLog.sync();
        this.partitionNexus.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() throws Exception {
        if (!this.started) {
            return;
        }
        this.changeLog.sync();
        this.changeLog.destroy();
        if (this.journal.isEnabled()) {
            this.journal.destroy();
        }
        this.partitionNexus.sync();
        this.partitionNexus.destroy();
        if (this.workerThread != null) {
            this.worker.stop = true;
            Object object = this.worker.lock;
            synchronized (object) {
                this.worker.lock.notify();
            }
            while (this.workerThread.isAlive()) {
                LOG.info("Waiting for SynchWorkerThread to die.");
                this.workerThread.join(500L);
            }
        }
        this.cacheService.destroy();
        if (this.lockFile != null) {
            try {
                this.lockFile.close();
            }
            catch (IOException e) {
                LOG.warn("couldn't delete the lock file {}", (Object)LOCK_FILE_NAME);
            }
        }
        this.started = false;
        this.setDefaultInterceptorConfigurations();
    }

    @Override
    public ReferralManager getReferralManager() {
        return this.referralManager;
    }

    @Override
    public void setReferralManager(ReferralManager referralManager) {
        this.referralManager = referralManager;
    }

    @Override
    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public LdapApiService getLdapCodecService() {
        return this.ldapCodecService;
    }

    @Override
    public SchemaPartition getSchemaPartition() {
        return this.schemaPartition;
    }

    @Override
    public void setSchemaPartition(SchemaPartition schemaPartition) {
        this.schemaPartition = schemaPartition;
    }

    @Override
    public DefaultPartitionNexus getPartitionNexus() {
        return this.partitionNexus;
    }

    public boolean isFirstStart() {
        return this.firstStart;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Entry newEntry(Dn dn) {
        return new DefaultEntry(this.schemaManager, dn);
    }

    private boolean createBootstrapEntries() throws Exception {
        Dn sysPrefRootDn;
        Dn interceptorsDn;
        Dn servicesDn;
        Dn partitionsDn;
        Dn configurationDn;
        Dn name;
        Dn groupDn;
        Dn userDn;
        boolean firstStart = false;
        if (!this.partitionNexus.hasEntry(new HasEntryOperationContext(this.adminSession, this.adminDn))) {
            firstStart = true;
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, this.adminDn);
            serverEntry.put("objectClass", "top", "person", "organizationalPerson", "inetOrgPerson");
            serverEntry.put("uid", "admin");
            serverEntry.put("userPassword", (byte[][])new byte[][]{PartitionNexus.ADMIN_PASSWORD_BYTES});
            serverEntry.put("displayName", "Directory Superuser");
            serverEntry.put("cn", "system administrator");
            serverEntry.put("sn", "administrator");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.put("displayName", "Directory Superuser");
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            TlsKeyGenerator.addKeyPair(serverEntry);
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        if (!this.partitionNexus.hasEntry(new HasEntryOperationContext(this.adminSession, userDn = this.getDnFactory().create("ou=users,ou=system")))) {
            firstStart = true;
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, userDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "users");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        if (!this.partitionNexus.hasEntry(new HasEntryOperationContext(this.adminSession, groupDn = this.getDnFactory().create("ou=groups,ou=system")))) {
            firstStart = true;
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, groupDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "groups");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        if (!this.partitionNexus.hasEntry(new HasEntryOperationContext(this.adminSession, name = this.getDnFactory().create("cn=Administrators,ou=groups,ou=system")))) {
            firstStart = true;
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, name);
            serverEntry.put("objectClass", "top", "groupOfUniqueNames");
            serverEntry.put("cn", "Administrators");
            serverEntry.put("uniqueMember", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        if (!this.partitionNexus.hasEntry(new HasEntryOperationContext(this.adminSession, configurationDn = this.getDnFactory().create("ou=configuration,ou=system")))) {
            firstStart = true;
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, configurationDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "configuration");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        if (!this.partitionNexus.hasEntry(new HasEntryOperationContext(this.adminSession, partitionsDn = this.getDnFactory().create("ou=partitions,ou=configuration,ou=system")))) {
            firstStart = true;
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, partitionsDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "partitions");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        if (!this.partitionNexus.hasEntry(new HasEntryOperationContext(this.adminSession, servicesDn = this.getDnFactory().create("ou=services,ou=configuration,ou=system")))) {
            firstStart = true;
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, servicesDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "services");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        if (!this.partitionNexus.hasEntry(new HasEntryOperationContext(this.adminSession, interceptorsDn = this.getDnFactory().create("ou=interceptors,ou=configuration,ou=system")))) {
            firstStart = true;
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, interceptorsDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "interceptors");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        if (!this.partitionNexus.hasEntry(new HasEntryOperationContext(this.adminSession, sysPrefRootDn = this.getDnFactory().create("prefNodeName=sysPrefRoot,ou=system")))) {
            firstStart = true;
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, sysPrefRootDn);
            serverEntry.put("objectClass", "top", "organizationalUnit", "extensibleObject");
            serverEntry.put("prefNodeName", "sysPrefRoot");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, serverEntry));
        }
        return firstStart;
    }

    private void showSecurityWarnings() throws Exception {
        boolean needToChangeAdminPassword = false;
        Dn adminDn = this.getDnFactory().create("uid=admin,ou=system");
        Entry adminEntry = this.partitionNexus.lookup(new LookupOperationContext(this.adminSession, adminDn));
        Value<?> userPassword = adminEntry.get("userPassword").get();
        needToChangeAdminPassword = Arrays.equals(PartitionNexus.ADMIN_PASSWORD_BYTES, userPassword.getBytes());
        if (needToChangeAdminPassword) {
            LOG.warn("You didn't change the admin password of directory service instance '" + this.instanceId + "'.  " + "Please update the admin password as soon as possible " + "to prevent a possible security breach.");
        }
    }

    private void createTestEntries() throws Exception {
        for (LdifEntry ldifEntry : this.testEntries) {
            try {
                LdifEntry ldifEntry2 = ldifEntry.clone();
                Entry entry = ldifEntry2.getEntry();
                String dn = ldifEntry2.getDn().getName();
                try {
                    this.getAdminSession().add(new DefaultEntry(this.schemaManager, entry));
                }
                catch (Exception e) {
                    LOG.warn(dn + " test entry already exists.", e);
                }
            }
            catch (CloneNotSupportedException cnse) {
                LOG.warn("Cannot clone the entry ", cnse);
            }
        }
    }

    private void initializeSystemPartition() throws Exception {
        Partition system = this.getSystemPartition();
        Dn systemSuffixDn = this.getDnFactory().create("ou=system");
        CoreSession adminSession = this.getAdminSession();
        if (!system.hasEntry(new HasEntryOperationContext(adminSession, systemSuffixDn))) {
            DefaultEntry systemEntry = new DefaultEntry(this.schemaManager, systemSuffixDn);
            systemEntry.put("objectClass", "top", "organizationalUnit", "extensibleObject");
            systemEntry.put("creatorsName", "uid=admin,ou=system");
            systemEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            systemEntry.add("entryCSN", this.getCSN().toString());
            systemEntry.add("entryUUID", UUID.randomUUID().toString());
            systemEntry.put(DnUtils.getRdnAttributeType("ou=system"), DnUtils.getRdnValue("ou=system"));
            AddOperationContext addOperationContext = new AddOperationContext(adminSession, systemEntry);
            system.add(addOperationContext);
        }
    }

    private void initialize() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("---> Initializing the DefaultDirectoryService ");
        }
        if (this.interceptors == null) {
            this.setDefaultInterceptorConfigurations();
        }
        this.cacheService = new CacheService();
        this.cacheService.initialize(this);
        this.accessControlAPCache = new DnNode();
        this.collectiveAttributeAPCache = new DnNode();
        this.subschemaAPCache = new DnNode();
        this.triggerExecutionAPCache = new DnNode();
        this.dnFactory = new DefaultDnFactory(this.schemaManager, this.cacheService.getCache("dnCache"));
        this.schemaPartition.initialize();
        this.partitions.add(this.schemaPartition);
        this.systemPartition.getSuffixDn().apply(this.schemaManager);
        this.adminDn = this.getDnFactory().create("uid=admin,ou=system");
        this.adminSession = new DefaultCoreSession(new LdapPrincipal(this.schemaManager, this.adminDn, AuthenticationLevel.STRONG), this);
        this.partitionNexus = new DefaultPartitionNexus(new DefaultEntry(this.schemaManager, Dn.ROOT_DSE));
        this.partitionNexus.setDirectoryService(this);
        this.partitionNexus.initialize();
        this.initializeSystemPartition();
        this.firstStart = this.createBootstrapEntries();
        this.initInterceptors();
        if (this.changeLog.isEnabled()) {
            this.changeLog.init(this);
            if (this.changeLog.isExposed() && this.changeLog.isTagSearchSupported()) {
                String clSuffix = ((TaggableSearchableChangeLogStore)this.changeLog.getChangeLogStore()).getPartition().getSuffixDn().getName();
                this.partitionNexus.getRootDse(null).add("changeLogContext", clSuffix);
            }
        }
        if (this.journal.isEnabled()) {
            this.journal.init(this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<--- DefaultDirectoryService initialized");
        }
    }

    private Entry readEntry(String text) {
        StringReader strIn = new StringReader(text);
        BufferedReader in = new BufferedReader(strIn);
        String line = null;
        DefaultEntry entry = new DefaultEntry();
        block6: while (true) {
            try {
                while ((line = in.readLine()) != null) {
                    String addedLine;
                    if (line.length() == 0 || Strings.isEmpty(addedLine = line.trim())) continue;
                    Attribute attribute = LdifReader.parseAttributeValue(addedLine);
                    Attribute oldAttribute = entry.get(attribute.getId());
                    if (oldAttribute != null) {
                        try {
                            oldAttribute.add(attribute.get());
                            entry.put(oldAttribute);
                            continue block6;
                        }
                        catch (LdapException ne) {
                            continue;
                        }
                    }
                    try {
                        entry.put(attribute);
                        continue block6;
                    }
                    catch (LdapException ne) {
                    }
                }
                break;
            }
            catch (IOException ioe) {
                // empty catch block
                break;
            }
        }
        return entry;
    }

    @Override
    public Entry newEntry(String ldif, String dn) {
        try {
            Entry entry = this.readEntry(ldif);
            Dn newDn = this.getDnFactory().create(dn);
            entry.setDn(newDn);
            DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, entry);
            return serverEntry;
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_78, ldif, dn));
            return null;
        }
    }

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    @Override
    public boolean isPasswordHidden() {
        return this.passwordHidden;
    }

    @Override
    public void setPasswordHidden(boolean passwordHidden) {
        this.passwordHidden = passwordHidden;
    }

    @Override
    public int getMaxPDUSize() {
        return this.maxPDUSize;
    }

    @Override
    public void setMaxPDUSize(int maxPDUSize) {
        if (maxPDUSize <= 0) {
            maxPDUSize = Integer.MAX_VALUE;
        }
        this.maxPDUSize = maxPDUSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interceptor getInterceptor(String interceptorName) {
        try {
            this.readLock.lock();
            Interceptor interceptor = this.interceptorNames.get(interceptorName);
            return interceptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void addFirst(Interceptor interceptor) throws LdapException {
        this.addInterceptor(interceptor, 0);
    }

    @Override
    public void addLast(Interceptor interceptor) throws LdapException {
        this.addInterceptor(interceptor, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAfter(String interceptorName, Interceptor interceptor) {
        try {
            int position = 0;
            this.writeLock.lock();
            for (Interceptor inter : this.interceptors) {
                if (interceptorName.equals(inter.getName())) break;
                ++position;
            }
            if (position == this.interceptors.size()) {
                this.interceptors.add(interceptor);
            } else {
                this.interceptors.add(position, interceptor);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void remove(String interceptorName) {
        this.removeOperationsList(interceptorName);
    }

    @Override
    public Csn getCSN() {
        return this.csnFactory.newInstance();
    }

    @Override
    public int getReplicaId() {
        return this.replicaId;
    }

    @Override
    public void setReplicaId(int replicaId) {
        if (replicaId < 0 || replicaId > 999) {
            LOG.error(I18n.err(I18n.ERR_79, new Object[0]));
            this.replicaId = 0;
        } else {
            this.replicaId = replicaId;
        }
    }

    @Override
    public long getSyncPeriodMillis() {
        return this.syncPeriodMillis;
    }

    @Override
    public void setSyncPeriodMillis(long syncPeriodMillis) {
        this.syncPeriodMillis = syncPeriodMillis;
    }

    @Override
    public String getContextCsn() {
        return this.contextCsn;
    }

    @Override
    public void setContextCsn(String lastKnownCsn) {
        this.contextCsn = lastKnownCsn;
    }

    private void lockWorkDir() {
        FileLock fileLock = null;
        try {
            this.lockFile = new RandomAccessFile(new File(this.instanceLayout.getInstanceDirectory(), LOCK_FILE_NAME), "rw");
            try {
                fileLock = this.lockFile.getChannel().tryLock(0L, 1L, false);
            }
            catch (IOException e) {
                LOG.error("failed to lock the work directory", e);
            }
            catch (OverlappingFileLockException e) {
                fileLock = null;
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("failed to lock the work directory", e);
        }
        if (fileLock == null || !fileLock.isValid()) {
            String message = "the working directory " + this.instanceLayout.getRunDirectory() + " has been locked by another directory service.";
            LOG.error(message);
            throw new RuntimeException(message);
        }
    }

    @Override
    public CacheService getCacheService() {
        return this.cacheService;
    }

    @Override
    public DnNode<AccessControlAdministrativePoint> getAccessControlAPCache() {
        return this.accessControlAPCache;
    }

    @Override
    public DnNode<CollectiveAttributeAdministrativePoint> getCollectiveAttributeAPCache() {
        return this.collectiveAttributeAPCache;
    }

    @Override
    public DnNode<SubschemaAdministrativePoint> getSubschemaAPCache() {
        return this.subschemaAPCache;
    }

    @Override
    public DnNode<TriggerExecutionAdministrativePoint> getTriggerExecutionAPCache() {
        return this.triggerExecutionAPCache;
    }

    @Override
    public boolean isPwdPolicyEnabled() {
        AuthenticationInterceptor authenticationInterceptor = (AuthenticationInterceptor)this.getInterceptor(InterceptorEnum.AUTHENTICATION_INTERCEPTOR.getName());
        if (authenticationInterceptor == null) {
            return false;
        }
        PpolicyConfigContainer pwdPolicyContainer = authenticationInterceptor.getPwdPolicyContainer();
        return pwdPolicyContainer != null && (pwdPolicyContainer.getDefaultPolicy() != null || pwdPolicyContainer.hasCustomConfigs());
    }

    @Override
    public DnFactory getDnFactory() {
        return this.dnFactory;
    }

    @Override
    public SubentryCache getSubentryCache() {
        return this.subentryCache;
    }

    @Override
    public SubtreeEvaluator getEvaluator() {
        return this.evaluator;
    }

    class SynchWorker
    implements Runnable {
        final Object lock = new Object();
        boolean stop;

        SynchWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(DefaultDirectoryService.this.syncPeriodMillis);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("SynchWorker failed to wait on lock.", e);
                    }
                }
                try {
                    DefaultDirectoryService.this.partitionNexus.sync();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_74, new Object[0]), e);
                }
            }
        }
    }
}

