/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.bindRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.BindRequestDecorator;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreSimpleAuth
extends GrammarAction<LdapMessageContainer<BindRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSimpleAuth.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSimpleAuth() {
        super("Store BindRequest Simple Authentication");
    }

    @Override
    public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
        BindRequest bindRequestMessage = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        bindRequestMessage.setSimple(true);
        if (tlv.getLength() == 0) {
            bindRequestMessage.setCredentials(StringConstants.EMPTY_BYTES);
        } else {
            bindRequestMessage.setCredentials(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("The simple authentication is : {}", (Object)Strings.dumpBytes(bindRequestMessage.getCredentials()));
        }
    }
}

