/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.normalizers;

import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdentifierNormalizer
extends Normalizer {
    public ObjectIdentifierNormalizer() {
        super("2.5.13.0");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        if (value == null) {
            return null;
        }
        String str = value.getString().trim();
        if (str.length() == 0) {
            return new StringValue("");
        }
        if (Character.isDigit(str.charAt(0))) {
            return new StringValue(str);
        }
        return new StringValue(Strings.toLowerCase(str));
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (value == null) {
            return null;
        }
        String str = value.trim();
        if (str.length() == 0) {
            return "";
        }
        if (Character.isDigit(str.charAt(0))) {
            return str;
        }
        return Strings.toLowerCase(str);
    }
}

