/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.net.SocketAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.changelog.LogChange;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.AbstractOperationContext;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.FilterParser;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareResponse;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponse;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.message.UnbindRequest;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.shared.util.Strings;

public class DefaultCoreSession
implements CoreSession {
    private final DirectoryService directoryService;
    private final LdapPrincipal authenticatedPrincipal;
    private final LdapPrincipal anonymousPrincipal;
    private LdapPrincipal authorizedPrincipal;

    public DefaultCoreSession(LdapPrincipal principal, DirectoryService directoryService) {
        this.directoryService = directoryService;
        this.authenticatedPrincipal = principal;
        this.anonymousPrincipal = new LdapPrincipal(directoryService.getSchemaManager());
    }

    private void setReferralHandling(AbstractOperationContext opContext, boolean ignoreReferral) {
        if (ignoreReferral) {
            opContext.ignoreReferral();
        } else {
            opContext.throwReferral();
        }
    }

    @Override
    public void add(Entry entry) throws LdapException {
        this.add(entry, LogChange.TRUE);
    }

    @Override
    public void add(Entry entry, boolean ignoreReferral) throws LdapException {
        this.add(entry, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void add(Entry entry, LogChange log) throws LdapException {
        AddOperationContext addContext = new AddOperationContext((CoreSession)this, entry);
        addContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(addContext);
    }

    @Override
    public void add(Entry entry, boolean ignoreReferral, LogChange log) throws LdapException {
        AddOperationContext addContext = new AddOperationContext((CoreSession)this, entry);
        addContext.setLogChange(log);
        this.setReferralHandling(addContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(addContext);
    }

    @Override
    public void add(AddRequest addRequest) throws LdapException {
        this.add(addRequest, LogChange.TRUE);
    }

    @Override
    public void add(AddRequest addRequest, LogChange log) throws LdapException {
        AddOperationContext addContext = new AddOperationContext((CoreSession)this, addRequest);
        addContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.add(addContext);
        }
        catch (LdapException e) {
            ((AddResponse)addRequest.getResultResponse()).addAllControls(addContext.getResponseControls());
            throw e;
        }
        ((AddResponse)addRequest.getResultResponse()).addAllControls(addContext.getResponseControls());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value<?> convertToValue(String oid, Object value) throws LdapException {
        void var3_8;
        Object var3_3 = null;
        AttributeType attributeType = this.directoryService.getSchemaManager().lookupAttributeTypeRegistry(oid);
        if (attributeType.getSyntax().isHumanReadable()) {
            if (value instanceof String) {
                StringValue stringValue = new StringValue(attributeType, (String)value);
                return var3_8;
            } else {
                if (!(value instanceof byte[])) throw new LdapException(I18n.err(I18n.ERR_309, oid));
                StringValue stringValue = new StringValue(attributeType, Strings.utf8ToString((byte[])value));
            }
            return var3_8;
        } else if (value instanceof String) {
            BinaryValue binaryValue = new BinaryValue(attributeType, Strings.getBytesUtf8((String)value));
            return var3_8;
        } else {
            if (!(value instanceof byte[])) throw new LdapException(I18n.err(I18n.ERR_309, oid));
            BinaryValue binaryValue = new BinaryValue(attributeType, (byte[])value);
        }
        return var3_8;
    }

    @Override
    public boolean compare(Dn dn, String oid, Object value) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(new CompareOperationContext(this, dn, oid, this.convertToValue(oid, value)));
    }

    @Override
    public boolean compare(Dn dn, String oid, Object value, boolean ignoreReferral) throws LdapException {
        CompareOperationContext compareContext = new CompareOperationContext(this, dn, oid, this.convertToValue(oid, value));
        this.setReferralHandling(compareContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(compareContext);
    }

    @Override
    public void delete(Dn dn) throws LdapException {
        this.delete(dn, LogChange.TRUE);
    }

    @Override
    public void delete(Dn dn, LogChange log) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext((CoreSession)this, dn);
        deleteContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(deleteContext);
    }

    @Override
    public void delete(Dn dn, boolean ignoreReferral) throws LdapException {
        this.delete(dn, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void delete(Dn dn, boolean ignoreReferral, LogChange log) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext((CoreSession)this, dn);
        deleteContext.setLogChange(log);
        this.setReferralHandling(deleteContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(deleteContext);
    }

    @Override
    public LdapPrincipal getAnonymousPrincipal() {
        return this.anonymousPrincipal;
    }

    @Override
    public LdapPrincipal getAuthenticatedPrincipal() {
        return this.authenticatedPrincipal;
    }

    @Override
    public AuthenticationLevel getAuthenticationLevel() {
        return this.getEffectivePrincipal().getAuthenticationLevel();
    }

    @Override
    public SocketAddress getClientAddress() {
        return null;
    }

    @Override
    public Set<Control> getControls() {
        return null;
    }

    @Override
    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    @Override
    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal == null) {
            return this.authenticatedPrincipal;
        }
        return this.authorizedPrincipal;
    }

    @Override
    public Set<OperationContext> getOutstandingOperations() {
        return null;
    }

    @Override
    public SocketAddress getServiceAddress() {
        return null;
    }

    @Override
    public boolean isConfidential() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean isAdministrator() {
        String normName = this.getEffectivePrincipal().getName();
        return normName.equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    @Override
    public boolean isAnAdministrator() {
        return this.isAdministrator();
    }

    @Override
    public EntryFilteringCursor list(Dn dn, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        ListOperationContext listContext = new ListOperationContext(this, dn, returningAttributes);
        listContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.list(listContext);
    }

    @Override
    public EntryFilteringCursor list(Dn dn, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes, long sizeLimit, int timeLimit) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        ListOperationContext listContext = new ListOperationContext(this, dn, returningAttributes);
        listContext.setSizeLimit(sizeLimit);
        listContext.setTimeLimit(timeLimit);
        listContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.list(listContext);
    }

    @Override
    public Entry lookup(Dn dn) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.lookup(new LookupOperationContext((CoreSession)this, dn));
    }

    @Override
    public Entry lookup(Dn dn, String ... attrIds) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        LookupOperationContext lookupContext = new LookupOperationContext(this, dn, attrIds);
        Entry entry = operationManager.lookup(lookupContext);
        return entry;
    }

    @Override
    public Entry lookup(Dn dn, Control[] controls, String ... attrIds) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        LookupOperationContext lookupContext = new LookupOperationContext(this, dn, attrIds);
        if (controls != null) {
            lookupContext.addRequestControls(controls);
        }
        Entry entry = operationManager.lookup(lookupContext);
        return entry;
    }

    @Override
    public void modify(Dn dn, Modification ... mods) throws LdapException {
        this.modify(dn, Arrays.asList(mods), LogChange.TRUE);
    }

    @Override
    public void modify(Dn dn, List<Modification> mods) throws LdapException {
        this.modify(dn, mods, LogChange.TRUE);
    }

    @Override
    public void modify(Dn dn, List<Modification> mods, LogChange log) throws LdapException {
        if (mods == null) {
            return;
        }
        ArrayList<Modification> serverModifications = new ArrayList<Modification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add(new DefaultModification(this.directoryService.getSchemaManager(), mod));
        }
        ModifyOperationContext modifyContext = new ModifyOperationContext(this, dn, serverModifications);
        modifyContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(modifyContext);
    }

    @Override
    public void modify(Dn dn, List<Modification> mods, boolean ignoreReferral) throws LdapException {
        this.modify(dn, mods, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void modify(Dn dn, List<Modification> mods, boolean ignoreReferral, LogChange log) throws LdapException {
        if (mods == null) {
            return;
        }
        ArrayList<Modification> serverModifications = new ArrayList<Modification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add(new DefaultModification(this.directoryService.getSchemaManager(), mod));
        }
        ModifyOperationContext modifyContext = new ModifyOperationContext(this, dn, serverModifications);
        this.setReferralHandling(modifyContext, ignoreReferral);
        modifyContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(modifyContext);
    }

    @Override
    public void move(Dn dn, Dn newParent) throws LdapException {
        this.move(dn, newParent, LogChange.TRUE);
    }

    @Override
    public void move(Dn dn, Dn newParent, LogChange log) throws LdapException {
        MoveOperationContext moveContext = new MoveOperationContext(this, dn, newParent);
        moveContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.move(moveContext);
    }

    @Override
    public void move(Dn dn, Dn newParent, boolean ignoreReferral) throws Exception {
        this.move(dn, newParent, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void move(Dn dn, Dn newParent, boolean ignoreReferral, LogChange log) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveOperationContext moveContext = new MoveOperationContext(this, dn, newParent);
        this.setReferralHandling(moveContext, ignoreReferral);
        moveContext.setLogChange(log);
        operationManager.move(moveContext);
    }

    @Override
    public void moveAndRename(Dn dn, Dn newParent, Rdn newRdn, boolean deleteOldRdn) throws LdapException {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, LogChange.TRUE);
    }

    @Override
    public void moveAndRename(Dn dn, Dn newSuperiorDn, Rdn newRdn, boolean deleteOldRdn, LogChange log) throws LdapException {
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext(this, dn, newSuperiorDn, newRdn, deleteOldRdn);
        moveAndRenameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.moveAndRename(moveAndRenameContext);
    }

    @Override
    public void moveAndRename(Dn dn, Dn newParent, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws LdapException {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void moveAndRename(Dn dn, Dn newParent, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral, LogChange log) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext(this, dn, newParent, newRdn, deleteOldRdn);
        moveAndRenameContext.setLogChange(log);
        this.setReferralHandling(moveAndRenameContext, ignoreReferral);
        operationManager.moveAndRename(moveAndRenameContext);
    }

    @Override
    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn) throws LdapException {
        this.rename(dn, newRdn, deleteOldRdn, LogChange.TRUE);
    }

    @Override
    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, LogChange log) throws LdapException {
        RenameOperationContext renameContext = new RenameOperationContext(this, dn, newRdn, deleteOldRdn);
        renameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.rename(renameContext);
    }

    @Override
    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws LdapException {
        this.rename(dn, newRdn, deleteOldRdn, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral, LogChange log) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        RenameOperationContext renameContext = new RenameOperationContext(this, dn, newRdn, deleteOldRdn);
        renameContext.setLogChange(log);
        this.setReferralHandling(renameContext, ignoreReferral);
        operationManager.rename(renameContext);
    }

    @Override
    public EntryFilteringCursor search(Dn dn, String filter) throws LdapException {
        return this.search(dn, filter, true);
    }

    @Override
    public EntryFilteringCursor search(Dn dn, String filter, boolean ignoreReferrals) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        ExprNode filterNode = null;
        try {
            filterNode = FilterParser.parse(this.directoryService.getSchemaManager(), filter);
        }
        catch (ParseException pe) {
            throw new LdapInvalidSearchFilterException(pe.getMessage());
        }
        SearchOperationContext searchContext = new SearchOperationContext(this, dn, SearchScope.OBJECT, filterNode, null);
        searchContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
        this.setReferralHandling(searchContext, ignoreReferrals);
        return operationManager.search(searchContext);
    }

    @Override
    public EntryFilteringCursor search(Dn dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        SearchOperationContext searchContext = new SearchOperationContext(this, dn, scope, filter, returningAttributes);
        searchContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.search(searchContext);
    }

    @Override
    public EntryFilteringCursor search(Dn dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes, long sizeLimit, int timeLimit) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        SearchOperationContext searchContext = new SearchOperationContext(this, dn, scope, filter, returningAttributes);
        searchContext.setAliasDerefMode(aliasDerefMode);
        searchContext.setSizeLimit(sizeLimit);
        searchContext.setTimeLimit(timeLimit);
        return operationManager.search(searchContext);
    }

    @Override
    public boolean isAnonymous() {
        return this.getEffectivePrincipal().getDn().isEmpty();
    }

    @Override
    public boolean compare(CompareRequest compareRequest) throws LdapException {
        CompareOperationContext compareContext = new CompareOperationContext((CoreSession)this, compareRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        boolean result = false;
        try {
            result = operationManager.compare(compareContext);
        }
        catch (LdapException e) {
            ((CompareResponse)compareRequest.getResultResponse()).addAllControls(compareContext.getResponseControls());
            throw e;
        }
        ((CompareResponse)compareRequest.getResultResponse()).addAllControls(compareContext.getResponseControls());
        return result;
    }

    @Override
    public void delete(DeleteRequest deleteRequest) throws LdapException {
        this.delete(deleteRequest, LogChange.TRUE);
    }

    @Override
    public void delete(DeleteRequest deleteRequest, LogChange log) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext((CoreSession)this, deleteRequest);
        deleteContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.delete(deleteContext);
        }
        catch (LdapException e) {
            ((DeleteResponse)deleteRequest.getResultResponse()).addAllControls(deleteContext.getResponseControls());
            throw e;
        }
        ((DeleteResponse)deleteRequest.getResultResponse()).addAllControls(deleteContext.getResponseControls());
    }

    @Override
    public boolean exists(String dn) throws LdapException {
        return this.exists(new Dn(dn));
    }

    @Override
    public boolean exists(Dn dn) throws LdapException {
        HasEntryOperationContext hasEntryContext = new HasEntryOperationContext(this, dn);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.hasEntry(hasEntryContext);
    }

    @Override
    public void modify(ModifyRequest modifyRequest) throws LdapException {
        this.modify(modifyRequest, LogChange.TRUE);
    }

    @Override
    public void modify(ModifyRequest modifyRequest, LogChange log) throws LdapException {
        ModifyOperationContext modifyContext = new ModifyOperationContext((CoreSession)this, modifyRequest);
        modifyContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.modify(modifyContext);
        }
        catch (LdapException e) {
            ((ModifyResponse)modifyRequest.getResultResponse()).addAllControls(modifyContext.getResponseControls());
            throw e;
        }
        ((ModifyResponse)modifyRequest.getResultResponse()).addAllControls(modifyContext.getResponseControls());
    }

    @Override
    public void move(ModifyDnRequest modifyDnRequest) throws LdapException {
        this.move(modifyDnRequest, LogChange.TRUE);
    }

    @Override
    public void move(ModifyDnRequest modifyDnRequest, LogChange log) throws LdapException {
        MoveOperationContext moveContext = new MoveOperationContext((CoreSession)this, modifyDnRequest);
        moveContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.move(moveContext);
        }
        catch (LdapException e) {
            ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(moveContext.getResponseControls());
            throw e;
        }
        ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(moveContext.getResponseControls());
    }

    @Override
    public void moveAndRename(ModifyDnRequest modifyDnRequest) throws LdapException {
        this.moveAndRename(modifyDnRequest, LogChange.TRUE);
    }

    @Override
    public void moveAndRename(ModifyDnRequest modifyDnRequest, LogChange log) throws LdapException {
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext((CoreSession)this, modifyDnRequest);
        moveAndRenameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.moveAndRename(moveAndRenameContext);
        }
        catch (LdapException e) {
            ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(moveAndRenameContext.getResponseControls());
            throw e;
        }
        ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(moveAndRenameContext.getResponseControls());
    }

    @Override
    public void rename(ModifyDnRequest modifyDnRequest) throws LdapException {
        this.rename(modifyDnRequest, LogChange.TRUE);
    }

    @Override
    public void rename(ModifyDnRequest modifyDnRequest, LogChange log) throws LdapException {
        RenameOperationContext renameContext = new RenameOperationContext((CoreSession)this, modifyDnRequest);
        renameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.rename(renameContext);
        }
        catch (LdapException e) {
            ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(renameContext.getResponseControls());
            throw e;
        }
        ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(renameContext.getResponseControls());
    }

    @Override
    public EntryFilteringCursor search(SearchRequest searchRequest) throws LdapException {
        SearchOperationContext searchContext = new SearchOperationContext((CoreSession)this, searchRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        EntryFilteringCursor cursor = null;
        try {
            cursor = operationManager.search(searchContext);
        }
        catch (LdapException e) {
            ((SearchResultDone)searchRequest.getResultResponse()).addAllControls(searchContext.getResponseControls());
            throw e;
        }
        ((SearchResultDone)searchRequest.getResultResponse()).addAllControls(searchContext.getResponseControls());
        return cursor;
    }

    @Override
    public void unbind() throws LdapException {
        UnbindOperationContext unbindContext = new UnbindOperationContext(this);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.unbind(unbindContext);
    }

    @Override
    public void unbind(UnbindRequest unbindRequest) throws LdapException {
        UnbindOperationContext unbindContext = new UnbindOperationContext((CoreSession)this, unbindRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.unbind(unbindContext);
    }
}

