/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.name.Dn;

public abstract class AbstractOperationContext
implements OperationContext {
    protected static final Control[] EMPTY_CONTROLS = new Control[0];
    protected Dn dn;
    protected Entry entry;
    protected Entry originalEntry;
    protected Map<String, Control> requestControls = new HashMap<String, Control>(4);
    protected Map<String, Control> responseControls = new HashMap<String, Control>(4);
    protected Collection<String> byPassed;
    protected List<String> interceptors;
    protected int currentInterceptor;
    protected LdapPrincipal authorizedPrincipal;
    protected CoreSession session;
    protected boolean throwReferral;

    public AbstractOperationContext(CoreSession session) {
        this.session = session;
        this.currentInterceptor = 0;
    }

    public AbstractOperationContext(CoreSession session, Dn dn) {
        this.dn = dn;
        this.session = session;
        this.ignoreReferral();
    }

    @Override
    public CoreSession getSession() {
        return this.session;
    }

    public void setSession(CoreSession session) {
        this.session = session;
    }

    protected void setAuthorizedPrincipal(LdapPrincipal authorizedPrincipal) {
        this.authorizedPrincipal = authorizedPrincipal;
    }

    @Override
    public Dn getDn() {
        return this.dn;
    }

    @Override
    public void setDn(Dn dn) {
        this.dn = dn;
    }

    @Override
    public void addRequestControl(Control requestControl) {
        this.requestControls.put(requestControl.getOid(), requestControl);
    }

    @Override
    public Control getRequestControl(String numericOid) {
        return this.requestControls.get(numericOid);
    }

    @Override
    public boolean hasRequestControl(String numericOid) {
        return this.requestControls.containsKey(numericOid);
    }

    @Override
    public boolean hasRequestControls() {
        return !this.requestControls.isEmpty();
    }

    @Override
    public void addResponseControl(Control responseControl) {
        this.responseControls.put(responseControl.getOid(), responseControl);
    }

    @Override
    public Control getResponseControl(String numericOid) {
        return this.responseControls.get(numericOid);
    }

    @Override
    public boolean hasResponseControl(String numericOid) {
        return this.responseControls.containsKey(numericOid);
    }

    @Override
    public Control[] getResponseControls() {
        if (this.responseControls.isEmpty()) {
            return EMPTY_CONTROLS;
        }
        return this.responseControls.values().toArray(EMPTY_CONTROLS);
    }

    @Override
    public boolean hasResponseControls() {
        return !this.responseControls.isEmpty();
    }

    @Override
    public int getResponseControlCount() {
        return this.responseControls.size();
    }

    @Override
    public void addRequestControls(Control[] requestControls) {
        for (Control c : requestControls) {
            this.requestControls.put(c.getOid(), c);
        }
    }

    public void setRequestControls(Map<String, Control> requestControls) {
        this.requestControls = requestControls;
    }

    @Override
    public abstract String getName();

    public Entry getOriginalEntry() {
        return this.originalEntry;
    }

    public void setOriginalEntry(Entry originalEntry) {
        this.originalEntry = originalEntry;
    }

    @Override
    public final void setInterceptors(List<String> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public final String getNextInterceptor() {
        if (this.currentInterceptor == this.interceptors.size()) {
            return "FINAL";
        }
        String interceptor = this.interceptors.get(this.currentInterceptor);
        ++this.currentInterceptor;
        return interceptor;
    }

    @Override
    public int getCurrentInterceptor() {
        return this.currentInterceptor;
    }

    @Override
    public void setCurrentInterceptor(int currentInterceptor) {
        this.currentInterceptor = currentInterceptor;
    }

    private void setup(AbstractOperationContext opContext) {
        opContext.setAuthorizedPrincipal(this.authorizedPrincipal);
    }

    @Override
    public void delete(Dn dn) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext(this.session, dn);
        this.setup(deleteContext);
        this.session.getDirectoryService().getOperationManager().delete(deleteContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        return this.session.getDirectoryService().getOperationManager().lookup(lookupContext);
    }

    @Override
    public LookupOperationContext newLookupContext(Dn dn) {
        LookupOperationContext lookupContext = new LookupOperationContext(this.session, dn);
        this.setup(lookupContext);
        return lookupContext;
    }

    @Override
    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal != null) {
            return this.authorizedPrincipal;
        }
        return this.session.getEffectivePrincipal();
    }

    @Override
    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    @Override
    public Entry getEntry() {
        return this.entry;
    }

    @Override
    public void throwReferral() {
        this.throwReferral = true;
    }

    @Override
    public boolean isReferralThrown() {
        return this.throwReferral;
    }

    @Override
    public void ignoreReferral() {
        this.throwReferral = false;
    }

    @Override
    public boolean isReferralIgnored() {
        return !this.throwReferral;
    }
}

