/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.constants;

import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LdapSecurityConstants {
    HASH_METHOD_SHA("sha"),
    HASH_METHOD_SSHA("ssha"),
    HASH_METHOD_MD5("md5"),
    HASH_METHOD_SMD5("smd5"),
    HASH_METHOD_CRYPT("crypt"),
    HASH_METHOD_SHA256("sha-256"),
    HASH_METHOD_SSHA256("ssha-256"),
    HASH_METHOD_SHA384("sha-384"),
    HASH_METHOD_SSHA384("ssha-384"),
    HASH_METHOD_SHA512("sha-512"),
    HASH_METHOD_SSHA512("ssha-512");

    private String name;

    private LdapSecurityConstants(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static LdapSecurityConstants getAlgorithm(String name) {
        String algorithm = "";
        if (name != null) {
            algorithm = Strings.toLowerCase(name);
        }
        if (HASH_METHOD_SHA.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA;
        }
        if (HASH_METHOD_SSHA.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA;
        }
        if (HASH_METHOD_MD5.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_MD5;
        }
        if (HASH_METHOD_SMD5.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SMD5;
        }
        if (HASH_METHOD_CRYPT.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_CRYPT;
        }
        if (HASH_METHOD_SHA256.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA256;
        }
        if (HASH_METHOD_SSHA256.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA256;
        }
        if (HASH_METHOD_SHA384.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA384;
        }
        if (HASH_METHOD_SSHA384.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA384;
        }
        if (HASH_METHOD_SHA512.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA512;
        }
        if (HASH_METHOD_SSHA512.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA512;
        }
        return null;
    }
}

